<?php

global $nombre_usuario, $grupo_usuario;

include('./include/functions.php');
/** Error reporting */

error_reporting(E_ALL);

date_default_timezone_set('Europe/London');

$year = date('Y');



/** PHPExcel */

require_once './class/PHPExcel.php';

// Create new PHPExcel object

$objPHPExcel = new PHPExcel();

// Set properties

$objPHPExcel->getProperties()->setCreator(COMPANY_NAME_REAL)

							 ->setLastModifiedBy("TMS")

							 ->setTitle("TMS - Magic Sales")

							 ->setSubject("From January")

							 ->setDescription("Only Magic Sales./n

								 From January to actual date/n

								 One line for each sale/n

								 ET2010xxxx  +  Net Total  +  CHF Rate (customer)/n

								 Net Total Summary")

							 ->setKeywords("tms magic sales")

							 ->setCategory("sales");

// Rename sheet

$objPHPExcel->getActiveSheet()->setTitle($year.' Magic Sales');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet

$objPHPExcel->setActiveSheetIndex(0);

// Add some data

$objPHPExcel->setActiveSheetIndex(0)

            ->setCellValue('A1', 'Customer No.')

            ->setCellValue('B1', 'Net Total')

            ->setCellValue('C1', 'CHF Rate');

// DB read

$sql = "SELECT c.`Customer Number` customer, c.`subtotal` subtotal, i.`Net Rate` rate FROM customers c, itineraries i WHERE (c.`Referred by`='MCH' OR `Referred by`='MEU') AND c.`subtotal` > 0 AND c.`When_updated` > '".$year."-01-01' AND c.`Customer Id` = i.`Customer Id` AND (c.`Visit Status` = 'success' OR c.`Visit Status` = 'customer') GROUP BY c.`Customer Number` ORDER BY c.`When_updated`";

$result=$db->query($sql);

$row = 2;

while ($magic = $db->fetchNextObject($result)) {

	$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $magic->customer);

	$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $magic->subtotal);

	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row, $magic->rate);

	$row++;

}

$rowlast = $row - 1;

$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, '=SUM(B2:B'.$rowlast.')');



// Redirect output to a client’s web browser (Excel5)

header('Content-Type: application/vnd.ms-excel');

header('Content-Disposition: attachment;filename="'.$year.'-magic-sales.xls"');

header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

$objWriter->save('php://output');

exit;