<?php

/*
 * Tool to delete customer from TMS
 */

include_once('../include/functions.php');

// Read customer id
if( isset($_POST['customer']) ) {
	if( is_numeric($_POST['customer']) ) {
		$customerId = intval($_POST['customer']);
	} else {
		$tbStatus = "<span style='height: 34px; line-height: 34px; display: inline-block;'><b style='color:orange; font-size:large;'>&nbsp;Wrong information submitted!</b></span>";
	}
}

// Proceed to delete record
if( isset($customerId) ) {
	// table array with table name and field name
	$tables = array(
		"customers" => "Customer Id",
		"cancellations" => "Customer Id",
		"customers_travel" => "Customer Id",
		"ecommerce" => "Customer Id",
		"itineraries" => "Customer Id",
		"leads" => "Customer Id",
		"reminders" => "customer_id",
		"vendors_commission" => "Customer Id",
		"vendors_feedback" => "Customer_Id",
	);
	// sum records removed
	$total_removed = 0;
	foreach($tables as $table => $field) {
		$query = "DELETE FROM `$table` WHERE `$field` = $customerId";
		$db->execute($query);
		$result = $db->lastAffectedRows();
		$msg = "Records deleted from $table: ";
		tms_debug($query, "SQL:");
		tms_debug($result, $msg);
		$total_removed += $result;
	}
	if( $total_removed > 0 ) {
		$tbStatus = "<span style='height: 34px; line-height: 34px; display: inline-block;'><b style='color:red; font-size:large;'>&nbsp;Customer #<i>$customerId</i> has been removed from database.</b></span>";
	} else {
		$tbStatus = "<span style='height: 34px; line-height: 34px; display: inline-block;'><b style='color:orange; font-size:large;'>&nbsp;Customer #<i>$customerId</i> was NOT found!</b></span>";
	}
}

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
		"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<title>Delete Customer Tool - Travel Management System - <?php echo COMPANY_NAME?></title>
	<style type="text/css">@import url("/system/include/Formitable_style.css");</style>
	<style type="text/css">@import url("/system/include/toolbars.css");</style>
	<style type="text/css">@import url("/system/include/menu.css");</style>
<!--[if IE]>
	<link rel="stylesheet" type="text/css" media="all" href="/system/include/prj_ie.css" />
<![endif]-->
<!--[if lt IE 7]>
	<script src="/system/include/iefix/IE7.js" type="text/javascript"></script>
<![endif]-->
	<style type="text/css">
		h3 { margin: 10px 0 0; padding: 0px; font-size:16px; color:#7381DD;}
		h4 { margin: 0px; padding: 0px; font-size:14px; font-weight:bold; text-align:right; width:inherit; color:#FF5396}
		label { margin: 0px; padding: 0px; font-size:14px}
		#reporte1, #reporte2, #reporte3 { border-top: 1px dotted #FF5396; border-right: 1px dotted #FF5396; border-bottom: 1px dotted #FF5396; padding: 5px; overflow: visible; width: 350px;}
	</style>
</head>
<body>
<?php include TMS_ROOT.'include/barrasuperior.php'?>
	<br /><br /><br />
	<div id="contenido">
		<div class="boxed">
			<h1 align="center">Delete Customer Tool</h1>
			<form method="POST" action="delete-customer.php" name="customer">
				<table align="center" width="15%"><tr>
					<td width="100%" valign="bottom">
						<label for="Customer_Id" class="textlabel" style="float:none;">Customer Id</label> <br />
						<input type="text" class="text" maxlength="10" size="10" id="Customer_Id" name="customer" style="float:none; width:100%;">
					</td></tr>
					<tr><td>
						<div class="button">
							<input type="submit" class="submit" value="Enter" name="submit">
						</div>
					</td>
				</tr></table>
			</form>
		</div>
	</div>
<?php include TMS_ROOT.'include/barrainferior.php'?>
</body>
</html>