<?
/** A PHP class to access SEO_STATUS table with convenient methods
  * in an object oriented way, and with a powerful debug system.\n
  * @version  1.0
  * @author   Juan Carlos Alvarez (juancarlos@costaricavirtual.com)
  */
if (!defined("TMS_ROOT")) {
die("TMS root path not defined");
}

// Include the class DB
include_once TMS_ROOT.'include/functions.php';

class SEO {
    /**
     * holds all variables(properties) of an object
     *
     * @var array
     * @access protected
     */
    var $vars = array();

	/**
     * initialize SEO object
     *
     * @access public
     * @param int $id index value
     */
    function SEO($id = null) {
		global $db;
		$this->initVar("id", -1);
		$this->initVar("website", -1);
		$this->initVar("original_url", -1);
		$this->initVar("new_url", -1);
		$this->initVar("original_title", -1);
		$this->initVar("original_description", -1);
		$this->initVar("original_keywords", -1);
		$this->initVar("search_phrase", -1);
		$this->initVar("original_rank_date", -1);
		$this->initVar("original_rank", -1);
		$this->initVar("new_rank_date", -1);
		$this->initVar("new_rank", -1);
		$this->initVar("new_title", -1);
		$this->initVar("new_description", -1);
		$this->initVar("new_keywords", -1);
		$this->initVar("comments", -1);
		
		if (isset($id)) {
			if (intval($id) > 0) {
				$sql = 'SELECT * FROM `seo_status` WHERE `id`='.$id;
				$this->assignVars($db->queryUniqueArray($sql));
			}
		}
	}
	
	/**
     * initialize variables for the object
     *
     * @access public
     * @param string $key
     * @param mixed $value
     */
    function initVar($key, $value = null)
    {
        $this->vars[$key] = array('value' => $value);
    }
	
	/**
     * assign a value to a variable
     *
     * @access public
     * @param string $key name of the variable to assign
     * @param mixed $value value to assign
     */
    function assignVar($key, $value)
    {
        if (isset($key) && isset($this->vars[$key])) {
			$this->vars[$key]['value'] =& $value;
		}
    }

    /**
     * assign values to multiple variables in a batch
     *
     * @access private
     * @param array $var_array associative array of values to assign
     */
    function assignVars($var_arr)
    {
        foreach ($var_arr as $key => $value) {
            $this->assignVar($key, $value);
        }
    }
	
	/**
     * returns a specific variable for the object
     *
     * @access public
     * @param string $key key of the object's variable to be returned
     */
    function getVar($key)
    {
        $ret = null;
        if (!isset($this->vars[$key])) {
            return $ret;
        }
        $ret =  $this->vars[$key]['value'];
        return $ret;
	}
	
	/**
	* retrieve items from the database
	*
	* @param string $criteria conditions to be met
	* @param string $groupBy order to be met
	* @param string $sortOrder order to be met
	* @return array array of objects 
	*/
	function &getObjects($criteria = '', $groupBy = '', $sortOrder = '')
	{
		global $db;
		$ret = false;
		$sql = 'SELECT * FROM `seo_status`';

		if ($criteria != '') {
			$sql .= " WHERE " . $criteria;
		}

		if ($groupBy != '') {
			$sql .= " GROUP BY " . $groupBy;
		}

		if ($sortOrder != '') {
			$sql .= ' ORDER BY '.$sortOrder;
		}
		
		$result = $db->query($sql);
		if (!$result) {
			return $ret;
		}
		
		$numrows = $db->numRows($result);
		if ($numrows == 0) {
			return $ret;
		}

		$theObjects = array();

		while ($myrow = $db->fetchNextArray($result)) {
			$item = new SEO();
			$item->assignVars($myrow);

			$theObjects[$myrow['id']] =& $item;
			unset($item);
		}
		$ret = $theObjects;
		
		return $ret;
	}

}
