<?php
// NOW INCLUDES ALL SERVICES FROM AN ITINERARY WITH CCF
/*
 * Filter: customer must exist on customer travel table
 * Filter: website is MCH
 * Filter: year created of customer record = $year or 1 year before
 * Filter: visit status = prospect, success, customer
 * Filter: arrival year = $year
 * Filter: customer must have itinerary
 * Filter: service is hotel or booking engine or vendor is Rail Source or vendor ir Rail Tour
 */
/*****
// GET VENDOR LIST BY HOTEL TYPE AND COUNTRY, WHEN SUCCESS SALE
SELECT DISTINCT i.`Vendor Name` `Hotel Name`, v.`Location`
FROM ats_TMS.itineraries i, ats_TMS.customers c, ats_TMS.vendors v
WHERE i.`Service Type` = 'Hotel'
AND i.`Vendor Id` = v.`Vendor Id`
AND v.`Country` = 'Switzerland'
AND i.`Customer Id` = c.`Customer Id`
AND c.`CC Billed` =1
AND c.`Visit Status` <> 'notinterested'
AND c.`Visit Status` <> 'process ended'
AND c.`Visit Status` <> 'test'
ORDER BY v.`Location` ASC, i.`Vendor Name` ASC

// GET VENDOR LIST BY BOOKING ENGINE AND COUNTRY, WHEN SUCCESS SALE
SELECT DISTINCT i.`Internal Comments` `Hotel Name`, v.`Location`
FROM ats_TMS.itineraries i, ats_TMS.customers c, ats_TMS.vendors v
WHERE i.`Service Type` = 'Booking Engine'
AND v.`Common Name` = i.`Internal Comments`
AND v.`Country` = 'Switzerland'
AND i.`Customer Id` = c.`Customer Id`
AND c.`CC Billed` =1
AND c.`Visit Status` <> 'notinterested'
AND c.`Visit Status` <> 'process ended'
AND c.`Visit Status` <> 'test'
ORDER BY v.`Location` ASC, i.`Internal Comments` ASC

-------------------------------------------------------------------

// GET VENDOR NIGHTS BY SPECIFIC HOTEL AND YEAR, WHEN HOTEL OR BOOKING ENGINE
SELECT i.`Number of Days` `Days`, i.`PAX`, (i.`Number of Days` * i.`PAX`) `nights`
FROM ats_TMS.itineraries i, ats_TMS.customers c
WHERE ( 
	(i.`Service Type` = 'Booking Engine' AND 'Hotel Hauser' = i.`Internal Comments`)
	OR (i.`Service Type` = 'Hotel' AND i.`Vendor Name` = 'Hotel Hauser') 
	)
AND YEAR( i.`From Date` ) =2013
AND i.`Customer Id` = c.`Customer Id`
AND c.`CC Billed` =1
AND c.`Visit Status` <> 'notinterested'
AND c.`Visit Status` <> 'process ended'
AND c.`Visit Status` <> 'test'
ORDER BY i.`From Date` ASC
*****/

global $nombre_usuario, $grupo_usuario;
include('../include/functions.php');
include('../class/db/access.php');
$clase = 'odd';
function clase() {
	global $clase;
	$clase = ($clase == 'odd') ? 'even': 'odd';
	return 'class="'.$clase.'"';
}

/*
 * Function get vendor nights by booking engine and hotel
 * Parameters
 * country	string		Country name
 * year		integer		Year
 * location	string		Location name (optional)
 *
 * Return array with query results
 */
function getNights($country, $year, $location='') {
	global $db;
	$where_location = ($location <> '') ? " AND v.Location LIKE '%$location%' ": '';
	// GET VENDOR NIGHTS BY LOCATION AND YEAR, WHEN BOOKING ENGINE
	// removed 		AND c.`CC Billed` = 1
	$query = "
SELECT v.`Location` `location`, v.`Common Name` `hotelName`, i.`Number of Days` `days`, i.`PAX` `pax`, (
i.`Number of Days` * i.`PAX`) `nights`, i.`Customer Id` customerId, v.`Vendor Id` vendorId, c.`Name` `cname`
FROM itineraries i, vendors v, customers c
WHERE i.`Service Type` = 'Booking Engine'
AND v.`Common Name` = i.`Internal Comments`
AND v.Country = '$country'
$where_location
AND YEAR( i.`From Date` ) = $year
AND i.`Customer Id` = c.`Customer Id`
AND i.`Ok to Pay` = 1
AND c.`Visit Status` <> 'notinterested'
AND c.`Visit Status` <> 'process ended'
AND c.`Visit Status` <> 'test'
ORDER BY i.`From Date` ASC";
	$result=$db->query($query);
	$nights = array();
	while ($line = $db->fetchNextObject($result)) {
		//fill array ( hotelname[total] hotelname[customerId][days]...
		$nights[$line->hotelName]['total'] 		+= $line->nights;
		$nights[$line->hotelName]['location'] 	= $line->location;
		$nights[$line->hotelName]['id'] 		= $line->vendorId;
		$nights[$line->hotelName]['customerId'][$line->customerId]['name']	 = $line->cname;
		$nights[$line->hotelName]['customerId'][$line->customerId]['days']	+= $line->days;
		$nights[$line->hotelName]['customerId'][$line->customerId]['pax']	+= $line->pax;
	}
// GET VENDOR NIGHTS BY LOCATION AND YEAR, WHEN HOTEL
	$query = "
SELECT v.`Location` `location`, i.`Vendor Name` `hotelName`, i.`Number of Days` `days`, i.`PAX` `pax`, (i.`Number of Days` * i.`PAX`) `nights`, i.`Customer Id` customerId, v.`Vendor Id` vendorId, c.`Name` `cname` 
FROM ats_TMS.itineraries i, ats_TMS.vendors v, ats_TMS.customers c
WHERE i.`Service Type` = 'Hotel'
AND i.`Vendor Id` = v.`Vendor Id`
AND v.Country = '$country'
$where_location
AND YEAR( i.`From Date` ) = $year
AND i.`Customer Id` = c.`Customer Id`
AND i.`Ok to Pay` = 1
AND c.`Visit Status` <> 'notinterested'
AND c.`Visit Status` <> 'process ended'
AND c.`Visit Status` <> 'test'
ORDER BY i.`From Date` ASC";
	$result=$db->query($query);
	while ($line = $db->fetchNextObject($result)) {
		//fill array ( hotelname[total] hotelname[customerId][days]...
		$nights[$line->hotelName]['total'] 		+= $line->nights;
		$nights[$line->hotelName]['location']	= $line->location;
		$nights[$line->hotelName]['id'] 		= $line->vendorId;
		$nights[$line->hotelName]['customerId'][$line->customerId]['name']	 = $line->cname;
		$nights[$line->hotelName]['customerId'][$line->customerId]['days']	+= $line->days;
		$nights[$line->hotelName]['customerId'][$line->customerId]['pax']	+= $line->pax;
	}
	// return array
	return $nights;
}
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
		"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<title>Total Nights by vendor or location - Travel Management System - <?php echo COMPANY_NAME?></title>
	<style type="text/css">@import url("../include/default.css");</style>
	<style type="text/css">@import url("../include/alert.css");</style>
	<style type="text/css">@import url("../include/alphacube.css");</style>
	<!--<link href="include/ajaxtabs.css" rel="stylesheet" type="text/css" />-->

	<script type="text/javascript" src="/system/include/prototype/prototype161.js"></script>
	<script type="text/javascript" src="/system/include/prototype/effects.js"></script>
 	<script type="text/javascript" src="/system/include/prototype/window.js"> </script>

	<link href="../include/ajaxtabs.css" rel="stylesheet" type="text/css" />
	<link type="text/css" href="">
	<style type="text/css">
		body	{font-family:Verdana,Arial,Helvetica,sans-serif;}
		h3		{font-size:14px;}
		a		{color:#7381DD; cursor:pointer; text-decoration:none}
		.even 	{background-color:ghostWhite;}
		.odd 	{background-color:honeyDew;}
		td 		{font-size:14px !important}
		td a 	{font-size:14px !important}
	</style>
	<script type="text/javascript" src="/system/include/tablesort/tablesort.js"></script>
	<style type="text/css">@import url("../include/tablesort/tablesort.css");</style>
	<style type="text/css">@import url("../include/toolbars.css");</style>
	<style type="text/css">@import url("../include/menu.css");</style>
	<style type="text/css">@import url("../include/Formitable_style.css");</style>
<!--[if IE]>
	<link rel="stylesheet" type="text/css" media="all" href="./include/prj_ie.css" />
<![endif]-->
<!--[if lt IE 7]>
	<script src="/system/include/iefix/IE7.js" type="text/javascript"></script>
<![endif]-->
</head>
<body>
<?php include('../include/barrasuperior.php')?>
	<br><br/><br/>
	<div id="contenido">
		<?php
		// read year var
		$year = ( !isset($_GET['year']) ) ? date(Y) : $_GET['year'];
		$yearbefore = $year - 1;
		// read country var
		$country = ( !isset($_GET['country']) ) ? 'Switzerland' : $_GET['country'];
		// read location var
		$location = ( !isset($_GET['location']) ) ? '' : $_GET['location'];
		// GET YEAR LIST
		$sql = "SELECT YEAR(When_updated) `year` 
			FROM customers 
			WHERE When_updated IS NOT NULL 
			AND `Visit Status` <> 'notinterested'
			AND `Visit Status` <> 'process ended'
			AND `Visit Status` <> 'test' 
			GROUP BY YEAR(When_updated) 
			ORDER BY YEAR(When_updated) DESC";
		$result=$db->query($sql);
		$years = '';
		while ($reporte= $db->fetchNextObject($result)) {
			// prepare year radio buttons
			$checked = ($year==$reporte->year) ? ' checked="checked"' : '';
			$years .= '<input type="radio" class="radio" value="'.$reporte->year.'" id="year'.$reporte->year.'" name="year"' . $checked . '><label for="year'.$reporte->year.'" class="radiolabel">'.$reporte->year.'</label><br>';
		}
		?>
		<h1>Total Nights in <?php echo $country?> - <?php echo $year?></h1>
		<blockquote style="font-size:9px;">
			Filtered by:
			<ul>
				<li>Country and Year. Select the options in the form at your left.</li>
				<li>Service Type: Hotel, Booking Engine.</li>
				<li>Field 'Ok to Pay' has 'Yes'</li>
			</ul>
			Click on any location to get only the hotels on this location.<br>
			Sort each column with a click on the header cell. Sort order change between ascending and descending. Multiple columns can be sorted at once by pressing "Shift" key while selecting the columns using either the keyboard or mouse.
		</blockquote>
		<table style="width:100%; border:0 none;">
			<tr>
				<td style="width:15%; border:0 none;" valign="top">
					<form action="total-nights.php" method="get" name="nights">
						<fieldset>
							<legend>Country</legend>
							<input type="radio" class="radio" value="Switzerland" id="countryCH" name="country"<?php if ($country=='Switzerland') echo ' checked="checked"'?>><label for="countryCH" class="radiolabel">Switzerland</label><br>
							<input type="radio" class="radio" value="Guatemala" id="countryGT" name="country"<?php if ($country=='Guatemala') echo ' checked="checked"'?>><label for="countryGT" class="radiolabel">Guatemala</label><br>
							<input type="radio" class="radio" value="Panama" id="countryPA" name="country"<?php if ($country=='Panama') echo ' checked="checked"'?>><label for="countryPA" class="radiolabel" checked="checked">Panama</label><br>
						</fieldset>
						<fieldset>
							<legend>Year</legend>
							<?php echo $years;?>
						</fieldset>
						<br>
						<div align="center"><input type="submit" value="ENTER" name="submit"></div>
					</form>
				</td>
				<td style="width:auto; border:0 none;" valign="top">
					<table id="tophotels" class="sortable-onload-0-0 rowstyle-alt colstyle-alt no-arrow" style="width:auto; margin:0;">
						<thead><tr>
							<th class="sortable">Hotel Name</th>
							<th class="sortable">Location</th>
							<th class="sortable-numeric">Nights</th>
						</tr></thead>
						<tbody>
					<?php 
						$hotel = getNights($country, $year, $location);
						$total_nights = 0;
						foreach ($hotel as $name => $value) {
							/*
							$hotel[$hotelName<tbody>]['total']
							$hotel[$hotelName]['location']
							$hotel[$hotelName]['id']
							$hotel[$hotelName]['customerId'][$customerId]['name']
							$hotel[$hotelName]['customerId'][$customerId]['days']
							$hotel[$hotelName]['customerId'][$customerId]['pax']
							*/
					?>
							<tr<?php echo $style?>>
								<td id=""><a href="<?php echo TMS?>vendors.php?vendor=<?php echo $hotel[$name]['id']?>" target="vendor" title="Visit Hotel record on a separate window"><?php echo $name?></a></td>
								<td id=""><a href="<?php echo TMS?>reports/total-nights.php?country=<?php echo $country?>&amp;year=<?php echo $year?>&amp;location=<?php echo $hotel[$name]['location']?>" title="Filter by location"><?php echo $hotel[$name]['location']?></a></td>
								<td align="right">
									<?php echo $hotel[$name]['total']?> <a onclick="showDetails('<?php echo $hotel[$name]['id']?>')" title="Show Detailed Info"><?php echo showIcon("zoom.png","Show Detailed Info")?></a>
									<div style="display:none">
										<div id="details<?php echo $hotel[$name]['id']?>">
											<table id="tb<?php echo $hotel[$name]['id']?>" class="rowstyle-alt colstyle-alt no-arrow" style="width:100%; margin:0;"><thead><tr><td>Customer</td><td>Days</td><td>PAX</td></thead></tr><tbody>
											<?php
											foreach ($hotel[$name]['customerId'] as $cId => $cField) {?>
												<tr><td><a href="<?php echo TMS?>customers.php?customer=<?php echo $cId?>" target="customer" title="Visit Customer Itinerary on a separate window"><?php echo $hotel[$name]['customerId'][$cId]['name']?></a></td><td><?php echo $hotel[$name]['customerId'][$cId]['days']?></td><td><?php echo $hotel[$name]['customerId'][$cId]['pax']?></td></tr>
											<?php
											}?>
											</tbody></table>
										</div>
									</div>
								</td>
							</tr>
					<?php
							$total_nights += $hotel[$name]['total'];
						} //end foreach
					?>
							<tr>
								<td id=""><span style="font-size: 1px;">*&nbsp;</span><h2>TOTAL NIGHTS</h2></td>
								<td id="">&nbsp;</td>
								<td align="right"><h2><?php echo $total_nights?></h2></td>
							</tr>

						</tbody>
					</table>
					<br><br>
					<h2>TOTAL NIGHTS: <?php echo $total_nights?></h2>
				</td>
			</tr>
		</table>
	</div>
	<br><br><br/>
	<script type="text/javascript">
		// Show nights detailed window
		function showDetails(hotel) {
			Dialog.alert(
				$('details'+hotel).innerHTML, 
				{className:"alert", width:400}
			);
		}
	</script>
<?php include('../include/barrainferior.php')?>
</body>
</html>