<?php 
    //header('Content-Type: text/xml; charset=ISO-8859-1');
    global $hostname, $database, $username, $password;
    include_once ("../include/functions.php");

    // Function mg_customers
    // parameters id        integer
    // parameters actions   string
    // parameters ecommerce string (ATS or MTS)
    // return string
    function mg_customers($id, $actions = 'view', $ecommerce) {
        global $db;
        // connect to soap on magento
        if($ecommerce == 'ATS') {
            $proxy = new SoapClient('https://cart.absolutetravel-llc.com/api/soap/?wsdl');
        } else {
            $proxy = new SoapClient('https://cart.magictravelservices.ch/api/soap/?wsdl');
        }
        $sessionId = $proxy->login('TMS', 'em-thun.09');

        // read GET variables
        //$actions = filter_input(INPUT_GET, 'a');
        //$id = is_numeric($_GET['i']) ? $_GET['i']: 0;

        switch ($actions) {
            case 'view':
                if($id > 0) {
                    // Get customer info
                    // var_dump($proxy->call($sessionId, 'customer.info', $id));
                    echo '<pre>';
                    print_r($proxy->call($sessionId, 'customer.info', $id));
                    echo '</pre>';
                } else {
                    // View all customers
                    // var_dump($proxy->call($sessionId, 'customer.list', array('filters', '*')));
                    echo '<pre>';
                    print_r($proxy->call($sessionId, 'customer.list', array('filters', '*')));
                    echo '</pre>';
                }
                break;

            case 'create':
                $sql="SELECT `Customer Number` Customer_Number, Name, Email FROM customers WHERE `Customer Id` = ".$id;
                $customer = $db->queryUniqueObject($sql);
                // Create new customer
                $newCustomer = array(
                    'firstname'  => $customer->Name,
                    'lastname'   => '.',
                    'email'      => $customer->Email,
                    'password'   => $customer->Customer_Number,
                    'store_id'   => 1,
                    'website_id' => 1,
                    'group_id'   => 1
                );
                $newCustomerId = $proxy->call($sessionId, 'customer.create', array($newCustomer));
                $return = '<span style="float: left; width: 10%; text-align: center; font-size:9px;">'. showIcon("magento-added.jpg","Customer exist on Magento").'<br>Customer added to E-Commerce.<div id="mgp'.$id.'"></div></span>';
                // Update TMS customer with magento id
                $sql="UPDATE customers SET magento_customer_id = ".$newCustomerId." WHERE `Customer Id` = ".$id."";
                $db->execute($sql);
                break;

            case 'delete':
                // Delete customer
                $proxy->call($sessionId, 'customer.delete', $id);
                break;

            case 'update';
                // Update customer
                $update = array('firstname' => 'Changed Firstname');
                $proxy->call($sessionId, 'customer.update', array($id, $update));
                break;

            default:
                break;
        }
        return $return;
    }

    // Function traduce
    // parameters service string
    // return string
    function traduce($service) {
        switch ($service) {
            case 'Transfer':
                $service = 'Traslado';
                break;
            case 'Airline':
                $service = 'Aerol&iacute;nea';
                break;
            case 'Consolidator':
                $service = 'Consolidador';
                break;
            case 'Car Rental':
                $service = 'Rent-a-car';
                break;
            case 'School':
                $service = 'Escuela';
                break;
            case 'Guide':
                $service = 'Gu&iacute;a';
                break;
            case 'Rail':
                $service = 'Tren';
                break;
            case 'Tourism Office':
                $service = 'Oficina de Turismo';
                break;
            case 'Vacation Home':
                $service = 'Casa Vacacional';
                break;
            case 'Various':
                $service = 'Varios';
        }
        return $service;
    }

    // Function mg_catalog
    // parameters id                integer (Customer Id/Product SKU)
    // parameters actions           string  (create/delete/update)
    // parameters ecommerce         string  (ATS or MTS)
    // parameters name              string
    // parameters short_description string
    // parameters description       string
    // parameters finance           object  (tms_finance object)
    // parameters price             number  (price to charge or 0)
    // return string
    function mg_catalog($id, $actions = 'view', $ecommerce, $name, $short_description, $description, $finance, $price = 0) {
        global $db;
        // connect to soap on magento
        if( $ecommerce == 'ATS' ) {
            $proxy = new SoapClient('https://cart.absolutetravel-llc.com/api/soap/?wsdl');
        } elseif( $ecommerce == 'MTS' ){
            $proxy = new SoapClient('https://cart.magictravelservices.ch/api/soap/?wsdl');
        }
        $sessionId = $proxy->login('TMS', 'em-thun.09');

        // read GET variables
        //$actions = filter_input(INPUT_GET, 'a');
        //$id = is_numeric($_GET['i']) ? $_GET['i']: 0;

        switch ($actions) {
            case 'view':
                if($id > 0) {
                    // Get product info
                    echo '<pre>';
                    print_r($proxy->call($sessionId, 'catalog_product.list', $id));
                    echo '</pre>';
                } else {
                    // View all products
                    // $result = $proxy->call($sessionId, 'catalog_product.list');
                    // var_dump($result);
                    echo '<pre>';
                    print_r($proxy->call($sessionId, 'catalog_product.list'));
                    echo '</pre>';
                }
                break;

            case 'create':
                // read customer info 
                $sql="SELECT `Customer Number` Customer_Number, `Language` FROM customers WHERE `Customer Id` = ".$id;
                $customer = $db->queryUniqueObject($sql);
                // get attribute set
                $attributeSets = $proxy->call($sessionId, 'product_attribute_set.list');
                $attributeSet = current($attributeSets);
                // get price if = 0
				if ( $price == 0 ) {
					$price = $finance->getTotalIncome();
				}
                // set arrays with magento data needed
                $array2 = array(
                    'categories' => array(2),
                    'websites' => array(1),
                    'name' => $name,
                    'description' => utf8_encode($description),
                    'short_description' => utf8_encode($short_description),
                    'weight' => '0',
                    'status' => '1',
                    'url_key' => $customer->Customer_Number.'-custom-itinerary',
                    'url_path' => $customer->Customer_Number.'-custom-itinerary',
                    'visibility' => '2',
                    'price' => $price,
                    'tax_class_id' => 0,
                    'meta_title' => 'Custom Itinerary',
                    'meta_keyword' => 'Custom Itinerary',
                    'meta_description' => 'Custom Itinerary'
                );
                $array1 = array(
                    'virtual', 
                    $attributeSet['set_id'], 
                    $customer->Customer_Number, 
                    $array2
                );
                // Create new product
                $newProduct = $proxy->call($sessionId, 'catalog_product.create', $array1);
                // Update TMS customer with magento product id
                $sql="UPDATE customers SET magento_ecommerce = '".$ecommerce."', magento_product_id = ".$newProduct." WHERE `Customer Id` = ".$id."";
                $db->execute($sql);

                //var_dump ($result);
                $return = $customer->Customer_Number.'-custom-itinerary.htm';
                break;

            case 'delete':
                // Delete product
                $proxy->call($sessionId, 'catalog_product.delete', $id);
                break;

            case 'update';
                // Update product
				$update = array(
					'name' => $name,
                    'description' => utf8_encode($description),
                    'short_description' => utf8_encode($short_description),
					'price' => $price
				);
                $proxy->call($sessionId, 'catalog_product.update', array($id, $update));
                break;

            default:
                break;
        }
        return $return;
    }

    // Function mg_catalog
    // parameters data		array containing...
	//		mg_name					product name
	//		mg_short_description	product summary
	//		mg_description			product description
	//		mg_price				price to charge
	//		mg_ecommerce			ATS / MTS
	//		Last_updated_by			user 
	//		Customer_Id				customer id
	//		action					create / delete / update 
	//		id						only when is an update, product id
    // return string
    function mg_catalog2($data) {
        global $db;
        // connect to soap on magento
        if( $data['mg_ecommerce']== 'ATS' ) {
            $proxy = new SoapClient('https://cart.absolutetravel-llc.com/api/soap/?wsdl');
        } elseif( $data['mg_ecommerce'] == 'MTS' ){
            $proxy = new SoapClient('https://cart.magictravelservices.ch/api/soap/?wsdl');
        }
        $sessionId = $proxy->login('TMS', 'em-thun.09');

        // read GET variables 
        //$actions = filter_input(INPUT_GET, 'a');
        //$id = is_numeric($_GET['i']) ? $_GET['i']: 0;

        switch ($data['action']) {
            case 'view':
                if($id > 0) {
                    // Get product info
                    echo '<pre>';
                    print_r($proxy->call($sessionId, 'catalog_product.list', $id));
                    echo '</pre>';
                } else {
                    // View all products
                    // $result = $proxy->call($sessionId, 'catalog_product.list');
                    // var_dump($result);
                    echo '<pre>';
                    print_r($proxy->call($sessionId, 'catalog_product.list'));
                    echo '</pre>';
                }
                break;

            case 'create':
                // read customer info 
                $sql="SELECT `Customer Number` Customer_Number, `Language` FROM customers WHERE `Customer Id` = ".$data['Customer_Id'];
                $customer = $db->queryUniqueObject($sql);
                // get attribute set
                $attributeSets = $proxy->call($sessionId, 'product_attribute_set.list');
                $attributeSet = current($attributeSets);
				// set sku for a new product
				$product_sku = $data['mg_ecommerce'] . $db->getAutoIncrement('ecommerce');
                // set arrays with magento data needed 
                $array2 = array(
                    'categories' => array(2),
                    'websites' => array(1),
                    'name' => $data['mg_name'],
                    'description' => utf8_encode(nl2br($data['mg_description'])),
                    'short_description' => utf8_encode(nl2br($data['mg_short_description'])),
                    'weight' => '0',
                    'status' => '1',
                    'url_key' => $product_sku.'-custom-itinerary',
                    'url_path' => $product_sku.'-custom-itinerary',
                    'visibility' => '2',
                    'price' => $data['mg_price'],
                    'tax_class_id' => 0,
                    'meta_title' => 'Custom Itinerary',
                    'meta_keyword' => 'Custom Itinerary',
                    'meta_description' => 'Custom Itinerary'
                );
                $array1 = array(
                    'virtual', 
                    $attributeSet['set_id'], 
                    $product_sku, 
                    $array2
                );
                // Create new product
				$when_updated = date("Y-m-d");
				try {
					$newProduct = $proxy->call($sessionId, 'catalog_product.create', $array1);
				} catch (\SoapFault $e) {
					echo $e->getMessage();
				}
                // Create record on ecommerce table with magento product id
				$sql = "INSERT INTO `ecommerce` (`Customer Id`, `mg_product_id`, `mg_product_sku`, `mg_product_name`, `mg_product_summary`, `mg_product_description`, `mg_product_price`, `when_updated`) 
				VALUES ('".$data['Customer_Id']."', '".$newProduct."', '".$product_sku."', '".char_encode($data['mg_name'])."', '".char_encode($data['mg_short_description'])."', '".char_encode($data['mg_description'])."', '".$data['mg_price']."', '".$when_updated."')";
                $db->execute($sql);

                //return e-commerce link
                $return = $product_sku.'-custom-itinerary.htm';
                break;

            case 'delete':
                // Delete product
                $proxy->call($sessionId, 'catalog_product.delete', $id);
                break;

            case 'update';
				// read ecommerce product id 
                $sql="SELECT `mg_product_id` FROM ecommerce WHERE `id` = ".$data['id'];
                $mg_product_id = $db->queryUniqueValue($sql);
                // Update product
				$update = array(
					'name' => $data['mg_name'],
                    'description' => utf8_encode(nl2br($data['mg_description'])),
                    'short_description' => utf8_encode(nl2br($data['mg_short_description'])),
					'price' => $data['mg_price']
				);
                $proxy->call($sessionId, 'catalog_product.update', array($mg_product_id, $update));
				// Update current link on TMS
				$when_updated = date("Y-m-d");
                // Create record on ecommerce table with magento product id
				$sql = "UPDATE `ecommerce` SET `mg_product_name`='".char_encode($data['mg_name'])."', `mg_product_summary`='".char_encode($data['mg_short_description'])."', `mg_product_description`='".char_encode($data['mg_description'])."', `mg_product_price`='".$data['mg_price']."', `when_updated`='".$when_updated."' WHERE `id` = ".$data['id'];
                $db->execute($sql);
				
                break;

            default:
                break;
        }
        return $return;
    }
