<?php
global $nombre_usuario, $grupo_usuario;
include('./include/functions.php');
include_once TMS_ROOT.'/class/tmsFinance.php';
$blocks = array();
$clase = 'odd';
function clase() {
    global $clase;
    $clase = ($clase == 'odd') ? 'even': 'odd';
    return 'class="'.$clase.'"';
}

// Lee los creditos de proveedores
$content = '<ul>';
$sql="SELECT `Common Name` Vendor, Vendor_Id, DATE_FORMAT(Due_Date, '%d.%b.%y') Due, Amount, Comment 
    FROM vCredits, vendors 
    WHERE `Vendor Id`=Vendor_Id AND (Status='pending' OR Status='approved' OR Status='valid') 
    ORDER BY Due_Date DESC";
$result=$db->query($sql);
while ($vcredit = $db->fetchNextObject($result)) { 
    $content .= '<li '.clase().' title="Comments: '.$vcredit->Comment.'"><a href="vendors.php?vendor='.$vcredit->Vendor_Id.'">'.
    $vcredit->Vendor.'</a> $'.money_format('%.2n',$vcredit->Amount).'<br>';
    $content .= 'Due Date: '.$vcredit->Due.'</li>';
}
$content .= '</ul>';
$blocks['Vendor Credits'] = $content;
$position['Vendor Credits'] = 'left';

// Lee las comisiones de agencia por pagar
if($grupo_usuario != 'Sales') {
    $content = '<ul>';
    $sql="SELECT c.`Customer Number` Number, c.`Customer Id` Id, c.Name Name, 
        c.`Last updated by` Agent, c.`Markup TA` Commission, c.TravelAgency AgencyId, 
        a.`name` Agency 
        FROM customers c, agencies a 
        WHERE c.`Markup TA` > 0 AND c.`Markup TA Paid` = 0 AND c.TravelAgency = a.id 
        AND (c.`Visit Status` = 'interested' OR c.`Visit Status` = 'prospect' 
        OR c.`Visit Status` = 'customer') ORDER BY c.`Customer Number` DESC";
    $result=$db->query($sql);
    while ($customer = $db->fetchNextObject($result)) { 
        $content .= '<li '.clase().'><a href="customers.php?customer='.$customer->Id.'">'.
        $customer->Name.' ('.$customer->Number.')</a> ';
        $content .= substr($customer->Agent,0,strpos($customer->Agent,' ')).'<br>';
        $content .= '<a href="agencies.php?agent='.$customer->AgencyId.'">'.
        $customer->Agency.'</a> $'.money_format('%.2n',$customer->Commission).'</li>';
    }
    $content .= '</ul>';
    $blocks['TA Commission'] = $content;
    $position['TA Commission'] = 'left';
}

// Lee los clientes pendientes
$content = '<ul>';
$extra1 = ($grupo_usuario == 'Sales') ? 
    " AND `Last updated by` = '".$nombre_usuario ."'" : '';
$sql="SELECT `Customer Number` Number, `Customer Id` Id, Name, `Last updated by` Agent 
    FROM customers WHERE `Options Sent` = 0".$extra1." AND
    (`Visit Status` = 'interested' OR `Visit Status` = 'prospect' OR `Visit Status` = 'customer') 
    ORDER BY `Customer Number` DESC";
$result=$db->query($sql);
while ($customer = $db->fetchNextObject($result)) { 
    $content .= '<li '.clase().'><a href="customers.php?customer='.$customer->Id.'">'.
    $customer->Name.' ('.$customer->Number.')</a><br>';
    $content .= $customer->Agent.'</li>';
}
$content .= '</ul>';
$blocks['Not Answered Customers'] = $content;
$position['Not Answered Customers'] = 'center';

// Lee los cobros pendientes
$content = '<ul>';
$extra1 = ($grupo_usuario == 'Sales') ? 
    " AND c.`Last updated by` = '".$nombre_usuario ."'" : '';
$sql="SELECT c.`Customer Id` Id, c.Name Name, c.`Customer Number` Number, 
    SUM(a.monto) Panel, (c.subtotal+c.Markup-c.Discount+c.procfee+c.`Add Markup`) Rack, 
    cr.monto Credito, d.netoDevolucion Devuelto, `Last updated by` Agent 
FROM $database.customers c
LEFT JOIN $dbpanel.pagos p ON c.`Customer Number` = p.CustomerId
LEFT JOIN $dbpanel.abonos a ON p.id_pago = a.pago
LEFT JOIN $dbpanel.devoluciones d ON p.id_pago = d.pago
LEFT JOIN $dbpanel.creditos cr ON c.`Credit Id` = cr.id_credito
WHERE c.`Visit Status`='prospect'".$extra1." AND c.subtotal > 0
GROUP BY p.CustomerId;";
$result=$db->query($sql);
while ($customer = $db->fetchNextObject($result)) { 
    if($customer->Panel > 0){
	$content .= '<li '.clase().'><a href="customers.php?customer='.$customer->Id.'">';
	$content .= $customer->Name.' ('.$customer->Number.')</a> ';
	$content .= substr($customer->Agent,0,strpos($customer->Agent,' ')).'<br>';
	$content .= 'TMS=$'.money_format('%.2n',$customer->Rack);
	$content .= ', Reimb.=$'.money_format('%.2n',$customer->Devuelto);
	$content .= ', Credit=$'.money_format('%.2n',$customer->Credito);
	$content .= ', Panel=$'.money_format('%.2n',$customer->Panel);
	$content .= ', Diff=$'.money_format('%.2n',$customer->Rack-$customer->Panel).'</li>';
    }
}
$content .= '</ul>';
$blocks['Prospects Incomplete'] = $content;
$position['Prospects Incomplete'] = 'center';

// Lista de los hoteles mas vendidos
$content = '<ul>';
$content .= "<li><a href='rep-tophotels.php'>** Full Report with multi-sortable columns **</a></li>";
if($grupo_usuario != 'Sales') {
	$europe = " REGEXP 'Austria|Belgium|Bulgaria|Cyprus|Czech Republic|Denmark|England|Estonia|Finland|France|Germany|Greece|Hungary|Ireland|Italy|Latvia|Lithuania|Luxembourg|Malta|Netherlands|Poland|Portugal|Romania|Slovakia|Slovenia|Spain|Sweden|Switzerland|United Kingdom'";
	$content .= '<li><strong>EUROPE</strong></li>';
	$sql = "SELECT sum(`Number of Days`) `Days`, sum(`PAX`) `Pax`, YEAR(`From Date`) `Year`,
	  sum(`Amount Confirmed`) Rack, sum(`Amount Paid`) Paid,
	  sum(`Amount Billed`)/sum(`Amount Confirmed`) Factor, i.`Vendor Id` `Id`, `Vendor Name` Name, Country
	FROM $database.itineraries i, $database.vendors v WHERE `Amount Paid`>0 AND 
		(`Service Type`='Hotel' OR `Service Type`='Booking Engine') AND i.`Vendor Id`=v.`Vendor Id`
		AND `Country` ".$europe." 
	GROUP BY `Year`, i.`Vendor Id` ORDER BY `Year` DESC, sum(`Amount Paid`) DESC LIMIT 20";
	$result=$db->query($sql);
	$yeartmp = 0;
	while ($vendor = $db->fetchNextObject($result)) { 
		if ($yeartmp <> $vendor->Year){
			$content .= '<li><strong>'.$vendor->Year.'</strong></li>';
			$yeartmp = $vendor->Year;
		}
		$content .= '<li '.clase().'><a href="vendors.php?vendor='.$vendor->Id.'">'.$vendor->Name.'</a> ';
		$content .= $vendor->Pax.' PAX, '.$vendor->Days.' Days<br>';
		$content .= 'Rack=$'.money_format('%.2n',$vendor->Rack).
			', Paid=$'.money_format('%.2n',$vendor->Paid).', Factor '.money_format('%.2n',$vendor->Factor).'</li>';
	}
} // end if grupo usuatio <> sales
$america = " REGEXP 'Guatemala|Panama|Costa Rica|Belize|Honduras|El Salvador|Nicaragua|Central America|Argentina|United States'";
$content .= '<li><strong>AMERICA</strong></li>';
$sql = "SELECT sum(`Number of Days`) `Days`, sum(`PAX`) `Pax`, YEAR(`From Date`) `Year`,
  sum(`Amount Confirmed`) Rack, sum(`Amount Paid`) Paid,
  sum(`Amount Billed`)/sum(`Amount Confirmed`) Factor, i.`Vendor Id` `Id`, `Vendor Name` Name, Country
FROM $database.itineraries i, $database.vendors v WHERE `Amount Paid`>0 AND 
    (`Service Type`='Hotel' OR `Service Type`='Booking Engine') AND i.`Vendor Id`=v.`Vendor Id`
    AND `Country` ".$america." 
GROUP BY `Year`, i.`Vendor Id` ORDER BY `Year` DESC, sum(`Amount Paid`) DESC LIMIT 20";
$result=$db->query($sql);
$yeartmp = 0;
while ($vendor = $db->fetchNextObject($result)) { 
    if ($yeartmp <> $vendor->Year){
        $content .= '<li><strong>'.$vendor->Year.'</strong></li>';
        $yeartmp = $vendor->Year;
    }
    $content .= '<li '.clase().'><a href="vendors.php?vendor='.$vendor->Id.'">'.$vendor->Name.'</a> ';
    $content .= $vendor->Pax.' PAX, '.$vendor->Days.' Days<br>';
    $content .= 'Rack=$'.money_format('%.2n',$vendor->Rack).
        ', Paid=$'.money_format('%.2n',$vendor->Paid).', Factor '.money_format('%.2n',$vendor->Factor).'</li>';
}
$content .= '</ul>';
$blocks['Top 20 Hotels'] = $content;
$position['Top 20 Hotels'] = 'right';
	

// Lista de clientes +1500 (+2 servicios esto ya no)
$content = '<ul>';
$content .= "<li><a href='rep-1500+.php'>** Full Report with multi-sortable columns **</a></li>";
$extra1 = ($grupo_usuario == 'Sales') ? 
    " AND c.`Last updated by` = '".$nombre_usuario ."'" : '';
$sql = "SELECT max(i.`To Date`) To_Date, COUNT(PAX) Cuenta, c.`Customer Id` Id,
    (`subtotal`-`Discount`+`procfee`+`Markup`+`Markup TA`) Total, `Name`, 
    `Customer Number` Number, `Visit Status` `status`, c.`Last updated by` Agent
FROM customers c, itineraries i
WHERE `Visit Status`<>'test' ".$extra1." AND `Visit Status`<>'notinterested' AND `Visit Status`<>'prospect'
    AND c.`Customer Id`=i.`Customer Id` AND i.`To Date` < CURDATE()
    AND (`subtotal`-`Discount`+`procfee`+`Markup`+`Markup TA`) > 1499
GROUP BY i.`Customer Id` ORDER BY to_date DESC, total LIMIT 20";
$result=$db->query($sql);
while ($customer = $db->fetchNextObject($result)) { 
    if ($customer->Cuenta>0) {
	$content .= '<li '.clase().'><a href="customers.php?customer='.$customer->Id.'">';
	$content .= $customer->Name.' ('.$customer->Number.')</a> ';
	$content .= substr($customer->Agent,0,strpos($customer->Agent,' ')).'<br>';
	$content .= 'Total=$'.money_format('%.2n',$customer->Total).
            ', '.$customer->Cuenta.' Services, Check Out='.$customer->To_Date.'</li>';
    }
}
$content .= '</ul>';
$blocks['Customers $>1500'] = $content;
$position['Customers $>1500'] = 'right';
	
// Lee los cobros con diferencias
$content = '<ul>';
$extra1 = ($grupo_usuario == 'Sales') ? 
    " AND c.`Last updated by` = '".$nombre_usuario ."'" : '';
$sql="SELECT c.`Customer Id` Id, c.`Customer Number` Number, c.Name Name, 
    SUM(a.monto) Panel, (c.subtotal+c.Markup-c.Discount+c.procfee+c.`Add Markup`) Rack, 
    d.netoDevolucion Devuelto, cr.monto Credito, c.`Last updated by` Agent, 
    p.comentario comentario
    FROM customers c
    LEFT JOIN $dbpanel.pagos p ON c.`Customer Number` = p.CustomerId
    LEFT JOIN $dbpanel.abonos a ON p.id_pago = a.pago
    LEFT JOIN $dbpanel.devoluciones d ON p.id_pago = d.pago
    LEFT JOIN $dbpanel.creditos cr ON c.`Credit Id` = cr.id_credito
    WHERE c.`subtotal`>0".$extra1." AND 
    (c.`Visit Status` = 'prospect' OR c.`Visit Status` = 'customer')
    GROUP BY p.CustomerId ORDER BY c.`Name`";
$result=$db->query($sql);
while ($customer = $db->fetchNextObject($result)) { 
    $diff = money_format('%.2n',$customer->Rack+$customer->Devuelto-$customer->Credito-$customer->Panel);
    if( $diff > 0 && $customer->Panel > 0) {
	$content .= '<li '.clase().' title="'.$customer->comentario.'"><a href="customers.php?customer='.$customer->Id.'">';
	$content .= $customer->Name.' ('.$customer->Number.')</a> ';
	$content .= substr($customer->Agent,0,strpos($customer->Agent,' ')).'<br>';
	$content .= 'TMS=$'.money_format('%.2n',$customer->Rack);
	$content .= ', Panel=$'.money_format('%.2n',$customer->Panel);
	$content .= ', Diff=$'.$diff;
	if( $customer->Devuelto > 0)
            $content .= ', Reimb.=$'.money_format('%.2n',$customer->Devuelto);
	if( $customer->Credito > 0)
            $content .= ', Credit=$'.money_format('%.2n',$customer->Credito);
	if( $customer->comentario != "")
            $content .= ' Comentarios '.$customer->comentario;
	$content .= '</li>';
    }
}
$content .= '</ul>';
$blocks['Finance Differences'] = $content;
$position['Finance Differences'] = 'left';

// Lee los pagos pendientes 
if($grupo_usuario != 'Sales') {
    $content = '<ul>';
    $sql="SELECT c.`Customer Id` Id, c.`Customer Number` Number, c.Name Name, 
        SUM(i.`Amount Billed`) Net, SUM(i.`Amount Paid`) Paid, SUM(a.`monto`) Charged, 
        c.`Last updated by` Agent, i.`Payment Due Date` Due
    FROM $database.customers c, $database.itineraries i, $dbpanel.pagos p, 
        $dbpanel.abonos a
    WHERE c.`Customer Id` = i.`Customer Id` AND c.`subtotal`>0
        AND c.`Customer Number` = p.CustomerId AND p.id_pago = a.pago
        AND c.`Visit Status` <> 'notinterested' AND c.`Visit Status` <> 'test'
        AND i.`Payment Due Date` >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
        AND DATE_ADD(CURDATE(), INTERVAL 7 DAY) >= i.`Payment Due Date`
    GROUP BY i.`Customer Id` ORDER BY i.`Payment Due Date` DESC, c.Name";
    $result=$db->query($sql);
    while ($customer = $db->fetchNextObject($result)) { 
        $diff = money_format('%.2n',$customer->Net-$customer->Paid);
        if( $diff > 0 && $customer->Charged > 0){
            $content .= '<li '.clase().'><a href="customers.php?customer='.$customer->Id.'">';
            $content .= $customer->Name.' ('.$customer->Number.')</a> ';
            $content .= substr($customer->Agent,0,strpos($customer->Agent,' ')).'<br>';
            $content .= 'Net=$'.money_format('%.2n',$customer->Net);
            $content .= ', Paid=$'.money_format('%.2n',$customer->Paid);
            $content .= ', Diff=$'.$diff.'<br>Payment Due Date='.$customer->Due.'</li>';
        }
    }
    $content .= '</ul>';
    $blocks['7 Next/Prev Due Payments'] = $content;
    $position['7 Next/Prev Due Payments'] = 'center';
}
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
		"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <title>Home - Travel Management System - <?php echo COMPANY_NAME?></title>
    <style type="text/css">@import url("include/default.css");</style>
    <style type="text/css">@import url("include/alert.css");</style>
    <style type="text/css">@import url("include/alphacube.css");</style>
    <style type="text/css">@import url("include/Formitable_style.css");</style>
    <link href="include/tablekit_style.css" rel="stylesheet" type="text/css" />
    <link href="include/ajaxtabs.css" rel="stylesheet" type="text/css" />
    <link type="text/css" href="">
    <style type="text/css">
        body			{ font-family:Verdana,Arial,Helvetica,sans-serif; }
        h3				{ font-size:14px; }
        hr.pme-hr		{ border: 0px solid; padding: 0px; margin: 0px; 
                                        border-top-width: 4px; height: 1px; width:100% }
        table.pme-main	{ border: #004d9c 1px solid; border-collapse: collapse; 
                                        border-spacing: 0px; font-size:9px; margin-top:7px; width:100%; }
        table.pme-navigation { border: #004d9c 0px solid; border-collapse: collapse; 
                                        border-spacing: 0px; }
        td.pme-navigation-0, td.pme-navigation-1 { white-space: nowrap; }
        th.pme-header	{ border: #004d9c 1px solid; padding: 1px; background: #add8e6; }
        td.pme-key-0, td.pme-value-0, td.pme-help-0, td.pme-navigation-0, td.pme-cell-0,
        td.pme-key-1, td.pme-value-1, td.pme-help-0, td.pme-navigation-1, td.pme-cell-1,
        td.pme-sortinfo, td.pme-filter { border: #004d9c 1px solid; padding: 3px; }
        td.pme-buttons { text-align: left;   }
        input.pme-add, input.pme-copy, input.pme-view, input.pme-change, input.pme-submit { display:none; }
        /*input.pme-add, input.pme-copy, input.pme-view, input.pme-change, input.pme-delete, input.pme-submit { display:none; }*/
        td.pme-message { text-align: center; }
        td.pme-stats   { text-align: right;  font-size:9px; }
        a {color:#7381DD; cursor:pointer; text-decoration:none}
        .blocks {margin: 0px 10px; float: left; width: 31%;}
        .blocks ul {border-width: 0px 2px 2px; border-color:#C1DAD7; border-style:solid; margin: 0px; margin-bottom:10px; padding:2px 2px 2px 15px;}
        .blocks h2 {margin: 0px !important; background-color: #778899; height: 20px; color:white; font-size:14px; text-align:center; -moz-border-radius: 10px 10px 0px 0px;}
        .blocks ul li {margin-bottom:5px;}
        .even {background-color:ghostWhite;}
        .odd {background-color:honeyDew;}
    </style>
    <script type="text/javascript" src="/system/include/prototype/prototype.js"></script>
    <script type="text/javascript" src="/system/include/prototype/window.js"> </script>
    <script type="text/javascript" src="/system/include/ajaxtabs/ajaxtabs.js"></script>
    <script type="text/javascript" src="/system/include/calendar/calendar.js"></script>
    <style type="text/css">@import url("include/toolbars.css");</style>
    <style type="text/css">@import url("include/menu.css");</style>
    <!--[if IE]>
        <link rel="stylesheet" type="text/css" media="all" href="./include/prj_ie.css" />
    <![endif]-->
    <!--[if lt IE 7]>
        <script src="/system/include/iefix/IE7.js" type="text/javascript"></script>
    <![endif]-->
</head>
<body>
    <?php include('include/barrasuperior.php')?>
    <br><br/><br/>
    <!--<div id="contenido">-->
    <?php
    echo '<div class="blocks" id="'.str_replace(' ', '_', $title).'">';
    foreach($blocks as $title => $description) {
        if ($position[$title] == 'left') {
            echo '<h2>'.$title.'</h2>';
            echo $description;
        }
    }
    echo '</div>';
    echo '<div class="blocks" id="'.str_replace(' ', '_', $title).'">';
    foreach($blocks as $title => $description) {
        if ($position[$title] == 'center') {
            echo '<h2>'.$title.'</h2>';
            echo $description;
        }
    }
    echo '</div>';
    echo '<div class="blocks" id="'.str_replace(' ', '_', $title).'">';
    foreach($blocks as $title => $description) {
        if ($position[$title] == 'right') {
            echo '<h2>'.$title.'</h2>';
            echo $description;
        }
    }
    echo '</div>';
    ?>
    <br style="clear: both;"/>
    <!--</div>-->
    <br><br><br/>
    <?php include('include/barrainferior.php')?>
</body>
</html>