<?php
/* Define login data. */
define("USERNAME", "juanca");			/* IMPORTANT! This is the username used for login. Set to a prefered by you! */
define("PASSWORD", "eb07bd3d6332a268ca5ab75aa560943b");

/* Define important directory and file names! Please use a trailing slash ("/") for all directory names! */
define("ROOT_DIR", "./documents/files/");				/* IMPORTANT! This is the directory where your files are stored. Set to a prefered by you! */
define("META_DIR", "./documents/meta/");				/* This is the directory which is used for storing all "meta data". */
define("META_ROOT_DIR", "root/");			/* This is a directory inside the META_DIR mirroring the ROOT_DIR with the "meta data". */
define("META_TAGS_DIR", "tags/");			/* This is a directory inside the META_DIR used to organize the tags. */
define("EDITABLE", "html htm txt php js css");		/* Define the extensions of the files which are allowed for editing. */
define("IMG_EXTENSIONS", "jpg JPG png PNG gif GIF");	/* Define extensions for image files. */
define("IMG_WIDTH", "150");				/* Define the width a picture should be previewed with. */

/* Define preferencies for title and date format. */
define("TITLE", "Documents System");				/* Define the title to be displayed. */
define("DATE_FORMAT", "m/d/Y H:i:s");			/* Set your prefered date format. Please refer to http://php.net/date for details. */

/* Define labels. */
define("LABEL_INFO", "±");				/* This is the label for the "info/edit(tags/description)" link. */
define("LABEL_EDIT", "⊕");				/* This is the label for the "edit" link. */
define("LABEL_MOVE", "→");				/* This is the label for the "move" link. */
define("LABEL_RENAME", "↔");			/* This is the label for the "rename" link. */
define("LABEL_DELETE", "&Oslash;");			/* This is the label for the "delete" link. */
define("LABEL_UP_DIR", "parent directory (../)");	/* This is used as a label for the directory above the current one. */
define("LABEL_ADD_TAGS", "add tags");			/* This is the label for the link displayed if no tags available. Comment out if not wished. */
define("LABEL_ADD_DESCRIPTION", "add description");	/* This is the label for the link displayed if no description available. Comment out if not wished. */

/* Define preferencies for the organization criteria. */
define("INCLUDE_CATEGORIES_AS_TAGS", 1);		/* NOT IMPLEMENTED YET! Define if the categories should be set as tags also. (1="TRUE" or 0="FALSE") */

  /*********************************************/
 /* Edit below if you know what you're doing! */
/*********************************************/

#########################################################
#	This is XODA - the KISSed Document Manager	#
#########################################################
#	Use it under the BSD license or.. loose it! :)	#
#########################################################
#	Visit http://xoda.org for more information.	#
#########################################################
#	Author: betso					#
#		(betso_AT_users_DOT_sourceforge_DOT_net)#
#########################################################
#	Enjoy! :)					#
#########################################################
#########################################################
#	CHANGELOG					#
#########################################################
#	0.0.3:	small bugfixes,				#
#		fix some typos,				#
#		added preview of the images,		#
#		added upload of multiple files,		#
#			(maximum size is displayed.)	#
#		added hints as acronyms for the		#
#			change of the settings.		#
#-------------------------------------------------------#
#	0.0.2:	bigfixes:				#
#			- tag adding,			#
#			- making important directories,	#
#		added this cute CHANGELOG,		#
#		added user identification (login),	#
#		added browser based change of:		#
#			- password,			#
#			- settings,			#
#			- labels.			#
#		added download a file from the web,	#
#		made the layout more ergonomic,		#
#		the output is				#
#			"Valid XHTML 1.0 Transitional"!	#
#-------------------------------------------------------#
#	0.0.1:	initial version - sexy and buggy. :)	#
#########################################################

session_start();
clearstatcache();

// ini_set (display_errors, 1); /* Uncomment to show debug information if problems occur. */

/* XODA specific settings. */
define("XD_VERSION", "0.0.3");				/* Define the version of "XODA". This should be kept for future features. :) */
define("PHPSELF", basename($_SERVER['PHP_SELF']));	/* Get the current filename. */

$_top_content = TITLE; /* . "@". $_SERVER['SERVER_NAME'];	/* Set the content of the "top" div. */

$pwd = ROOT_DIR;

/* Functions start here. */
function xd_init () {
	if (!file_exists (ROOT_DIR)) xd_mkdirp (ROOT_DIR);
	if (!file_exists (META_DIR)) xd_mkdirp (META_DIR);
}

function xd_logout () {
	$_SESSION = array("login" => "false");
	if (isset($_COOKIE[session_name()])) setcookie(session_name(), '', time()-42000, '/');
	session_unset();
	session_destroy();
	return true;
}

function xd_pwd () {
	if (isset($_GET['subdir']) && strstr($_GET['subdir'], "..")) $pwd = ROOT_DIR;	/* If there is an attempt to access a higher directory, strip the working directory to ROOT_DIR. */
	else $pwd = ROOT_DIR . $_GET['subdir'];
	return $pwd;
}

function xd_rmrf ($dir) {
	if (is_dir ($dir)) {
		if ($files = glob ($dir."/*")) {
			foreach ($files as $file) {
				if (is_dir ($file)) xd_rmrf ($file);
				else { if (!unlink ($file)) return false; }
			}
		}
		if (!rmdir ($dir)) return false;
	} else if (!unlink ($dir)) return false;
	return true;
}

function xd_mkdirp ($path) {	/* This is an adapted version of David Pullen's function found on php.net (http://php.net/manual/en/function.mkdir.php#53337). Thanks, Dave! :)*/
	if (substr ($path, -1) == '/') $path = substr ($path, 0, -1);	/* Trim the trailing slash as `mkdir` in PHP5 doesn't like it. */
	if (!file_exists($path)) {
		xd_mkdirp (dirname($path));
		if (!mkdir($path, 0755)) return false;
	}
	return true;
}

function xd_getdirs ($dir) {
	static $dirs = array();
	if ($files = glob($dir."*", GLOB_ONLYDIR)) {
		foreach($files as $file) {
			$dirs[] = str_replace(ROOT_DIR, "/", $file);
			xd_getdirs($file . "/");
		}
	}
	return $dirs;
}

function xd_count_files ($dir, $what, &$count) {
	if ($files = glob($dir."/*")) {
		foreach ($files as $file) {
			if (!is_dir($file)) $count['files']++;
			else { $count['dirs']++; xd_count_files ($file . "/", $what, $count); }
		}
	}
	if (!empty ($count["$what"])) return $count["$what"];
	else return 0;
}

function xd_get_dir_content ($filename) {
	$dh = opendir($filename);
	while (($file = readdir($dh)) !== false) if (($file != ".") && ($file != "..")) $dir_content[] = $file;
	return $dir_content;
}

function xd_file_content_type ($filename) {
	return trim (exec('file -b ' . escapeshellarg($filename)));
}

function xd_file_owner ($filename) {
	if (function_exists (posix_getpwuid)) {
		$owner = posix_getpwuid (fileowner($filename));
		return $owner['name'];
	}
	else return fileowner ($filename);
}

function xd_file_group ($filename) {
	if (function_exists (posix_getgrgid)) {
		$group = posix_getgrgid (filegroup($filename));
		return $group['name'];
	}
	else return filegroup ($filename);
}

function xd_dir_size($dir) {
	if (!is_link($dir)) $s = stat($dir);
	else $s = 0;
	$size = $s["blocks"]*512;
	if (is_dir($dir)) {
		$dh = opendir($dir);
		while (($file = readdir($dh)) !== false)
		if ($file != "." and $file != "..") $size += xd_dir_size($dir."/".$file);
		closedir($dh);
	}
	return $size;
}

/* Thanks to "php dot net at alan-smith dot no-ip dot com"@http://php.net/manual/en/function.filesize.php#64387 for this function. */
function xd_file_size($filename) {
	if (is_dir($filename)) $size = xd_dir_size($filename);
	else $size = filesize($filename);
	$i=0;
	$iec = array("M", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB");
	while (($size/1024)>1) {
		$size=$size/1024;
		$i++;
	}
	return substr($size,0,strpos($size,'.')+4) . " " . $iec[$i];
}

function xd_max_upload_size () {
	$umf = ini_get('upload_max_filesize');
	$pms = ini_get('post_max_size');
	if ($umf > $pms) return $umf;
	else return $pms;
}

/* I cannot write something like this. Thanks to the function manual of "fileperms" (http://php.net/manual/en/function.fileperms.php)! :) */
function xd_file_permissions ($filename) {
	$perms = fileperms($filename);
	if (($perms & 0xC000) == 0xC000) $info = 's';
	elseif (($perms & 0xA000) == 0xA000) $info = 'l';
	elseif (($perms & 0x8000) == 0x8000) $info = '-';
	elseif (($perms & 0x6000) == 0x6000) $info = 'b';
	elseif (($perms & 0x4000) == 0x4000) $info = 'd';
	elseif (($perms & 0x2000) == 0x2000) $info = 'c';
	elseif (($perms & 0x1000) == 0x1000) $info = 'p';
	else $info = 'u';

	$info .= (($perms & 0x0100) ? 'r' : '-');
	$info .= (($perms & 0x0080) ? 'w' : '-');
	$info .= (($perms & 0x0040) ? (($perms & 0x0800) ? 's' : 'x' ) : (($perms & 0x0800) ? 'S' : '-'));
	$info .= (($perms & 0x0020) ? 'r' : '-');
	$info .= (($perms & 0x0010) ? 'w' : '-');
	$info .= (($perms & 0x0008) ? (($perms & 0x0400) ? 's' : 'x' ) : (($perms & 0x0400) ? 'S' : '-'));
	$info .= (($perms & 0x0004) ? 'r' : '-');
	$info .= (($perms & 0x0002) ? 'w' : '-');
	$info .= (($perms & 0x0001) ? (($perms & 0x0200) ? 't' : 'x' ) : (($perms & 0x0200) ? 'T' : '-'));
	return $info;
}

function xd_create_info ($filename) {
	global $acceso_usuario;
	$fileinfo = "<table border=\"0\" padding=\"3\" width=\"100%\">\n";

	$fileinfo .="\t<tr>\n";
	$fileinfo .="\t\t<td>\n";
	$fileinfo .="\t\t\tName: \n";
	$fileinfo .="\t\t\t<hr class=\"line\" />\n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t\t<td>\n";
	$fileinfo .="\t\t\t" . str_replace(ROOT_DIR, "", $filename)  . "\n";
	$fileinfo .="\t\t\t<hr class=\"line\" />\n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t</tr>\n";

	$fileinfo .="\t<tr>\n";
	$fileinfo .="\t\t<td>\n";
	$fileinfo .="\t\t\tType: \n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t\t<td>\n";
	$fileinfo .="\t\t\t" . xd_file_content_type($filename) . "\n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t</tr>\n";

	$fileinfo .="\t<tr>\n";
	$fileinfo .="\t\t<td>\n";
	$fileinfo .="\t\t\tSize: \n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t\t<td>\n";
	$fileinfo .="\t\t\t" . xd_file_size($filename) . "\n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t</tr>\n";

	/* Show a preview if the file is a picture as defined in IMG_EXTENSIONS. */
	if (in_array(end(explode(".", $filename)), explode(" ", IMG_EXTENSIONS))) {
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tPreview: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t<img src=\"" . $filename . "\" width=\"" . IMG_WIDTH . "\" border=\"1\" />\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	}

	/* Show additional information about a directory. */
	if (is_dir($filename)) {
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tFiles: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . @xd_count_files ($filename, "files") . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";

		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tDirectories: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . @xd_count_files ($filename, "dirs") . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	}
	if ($acceso_usuario == 'Administrator') {
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tOwner: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . xd_file_owner($filename) . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tGroup: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . xd_file_group($filename) . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";

		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tPermissions: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . xd_file_permissions($filename) . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tLast accessed: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . date(DATE_FORMAT, fileatime($filename)) . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\tLast modified: \n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t\t<td>\n";
		$fileinfo .="\t\t\t" . date(DATE_FORMAT, filemtime($filename)) . "\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	}
	
	$meta_file = META_DIR . META_ROOT_DIR . str_replace(ROOT_DIR, "", $filename) . "-xd_meta.php";
	if (file_exists($meta_file)) include $meta_file;
	if (!isset($_description)) $_description = "";
	if (!isset($_tags)) $_tags = "";

	if ($acceso_usuario == 'Administrator') {
		$fileinfo .="\t<tr>\n";
		$fileinfo .="\t\t<td colspan=\"2\">\n";
		$fileinfo .="\t\t\t<hr class=\"line\" />\n";
		$fileinfo .="\t<form method=\"post\" action=\"" . PHPSELF . "?edited_tags=" . $filename . "\">\n";
		$fileinfo .="\t\t\tTags:\n";
		$fileinfo .="\t<input class=\"input\" name=\"edit_tags\" value=\"" . htmlentities($_tags) . "\" />\n";
		$fileinfo .="\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"edit tags\">\n";
		$fileinfo .="\t</form>\n";
		$fileinfo .="\t\t</td>\n";
		$fileinfo .="\t</tr>\n";
	}
	
	$fileinfo .="\t<tr>\n";
	$fileinfo .="\t\t<td colspan=\"2\">\n";
	$fileinfo .="\t\t\t<hr class=\"line\" />\n";
	$fileinfo .="\t\t\tDescription:<br />\n";
	$fileinfo .="\t<form method=\"post\" action=\"" . PHPSELF . "?edited_description=" . $filename . "\">\n";
	$fileinfo .="\t<textarea class=\"edit\" name=\"edit_description\">" . htmlentities($_description) . "</textarea>\n";
	$fileinfo .="\t<br />\n";
	$fileinfo .="\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"edit description\">\n";
	$fileinfo .="\t</form>\n";
	$fileinfo .="\t\t</td>\n";
	$fileinfo .="\t</tr>\n";

	$fileinfo .= "</table>\n";

	return $fileinfo;
}

function xd_create_row ($filename, $rowstyle) {
	global $pwd, $subdir, $self, $acceso_usuario;
	if (isset($subdir) && $filename != $subdir . "/..") $filename = $subdir . "/" . basename($filename);
	$filepath = ROOT_DIR . $filename;

	echo ("\t<tr" . $rowstyle . ">\n");
	if ($filename == $subdir . "/..") {
		echo ("\t\t\t<td colspan=\"2\">\n");
		if (count(explode("/", $filepath)) < 4) echo ("\t\t\t\t<a href=\"" . PHPSELF . "\">" . LABEL_UP_DIR . "</a>\n");
		else echo ("\t\t\t<a href=\"" . PHPSELF . "?subdir=" . dirname($subdir) . "\">" . LABEL_UP_DIR . "</a>\n");
	} else {
		echo ("\t\t<td" . $rowstyle . ">\n");
		if (is_dir($filepath)) echo ("\t\t\t<a href=\"" . PHPSELF . "?subdir=" . $filename . "\">" . basename($filename) . "/</a>\n");
		else echo ("\t\t\t<a href=\"" . $filepath . "\" target='_blank'>" . basename($filename) . "</a>\n");
		echo ("\t\t</td>\n");
		echo ("\t\t<td" . $rowstyle . ">\n");
		echo ("\t\t\t<a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?info=" . $filepath . "', false); return false\" title=\"info about '" . $filename . "'\">" . LABEL_INFO . "</a>\n");
		echo ("\t\t\t<a href=\"".PHPSELF."?delete=".$filepath."&tag=".$_GET['tag']."\" title=\"delete\" onclick=\"if(checkDelete() == true) {return true;} else {return false;}\">" . LABEL_DELETE . "</a>\n");
		echo ("\t\t\t<a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?rename=" . $filepath . "', false); return false\" title=\"rename '" . $filename . "'\">" . LABEL_RENAME . "</a>\n");
		echo ("\t\t\t<a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?move=" . $filepath . "', false); return false\" title=\"move '" . $filename . "' to another directory\">" . LABEL_MOVE . "</a>\n");
		if (in_array(strtolower(end(explode('.', basename($filename)))), explode(" ", EDITABLE)) && (!is_dir(ROOT_DIR . $filename))) { echo ("\t\t\t<a href=\"" . PHPSELF . "?edit=" . $filepath . "\" title=\"edit\">" . LABEL_EDIT . "</a>\n"); }
		$meta_file = META_DIR . META_ROOT_DIR . $filename . "-xd_meta.php";
		if (file_exists($meta_file)) include $meta_file;
	}
	/* Show a description if set. */
	echo ("\t\t<td class=\"descr\">\n");
	if (!empty($_description) || isset($_description)) echo ("\t\t\t" . $_description . "\n");
	else if (($filename != $subdir . "/..") && defined("LABEL_ADD_DESCRIPTION")) echo ("\t\t\t<a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?info=" . $filepath . "', false); return false\" title=\"add description for '" . $filename . "'\">" . LABEL_ADD_DESCRIPTION . "</a>\n");
	echo ("\t\t</td>\n");
	/* Show the tags if set. */
	if ($acceso_usuario == 'Administrator') {
		echo ("\t\t<td class=\"tags\">\n");
		if (!empty($_tags) || isset($_tags)) xd_show_tags($_tags);
		else if (($filename != $subdir . "/..") && defined("LABEL_ADD_TAGS")) echo ("\t\t\t<a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?info=" . $filepath . "', false); return false\" title=\"add tags for '" . $filename . "'\">" . LABEL_ADD_TAGS . "</a>\n");
		echo ("\t\t</td>\n");
	}
	echo ("\t</tr>\n");
}

function xd_list_them($files) {
	if(!empty($files)) {
		$lightrow = " class=\"lightrow\"";
		$darkrow = " class=\"darkrow\"";
		$i=1;
		foreach ($files as $single_file) {
			if ($i % 2) $rowstyle = $lightrow;
			else $rowstyle = $darkrow;
			xd_create_row($single_file, $rowstyle);
			$i++;
		}
	} else {
		echo ("\t<tr>\n");
		echo ("\t\t\t<td>\n");
		echo ("\t\t\tNo documents uploaded already\n");
		echo ("\t\t\t</td>\n");
		echo ("\t</tr>\n");
	}
}

function xd_metafile_of ($filename) {
	return (META_DIR . META_ROOT_DIR . str_replace(ROOT_DIR, "", $filename) . "-xd_meta.php");
}

function xd_file_put_content ($filename, $content) {
	if (!file_exists (dirname($filename))) xd_mkdirp (dirname($filename));
	if (!file_exists ($filename)) {
		if (!$fp = fopen ($filename, 'x')) die ("ERROR: Cannot create file $filename");
	}
	if (is_writable ($filename)) {
		if (!$fp = fopen ($filename, 'w')) die ("ERROR: Cannot open file $filename");
		if (fwrite ($fp, $content) == FALSE) die ("ERROR: Cannot write to file $filename");
		fclose ($fp);
	} else die ("ERROR: The file $filename is not writable!");
	chmod($filename, 0606);
	return true;
}

function xd_show_tags ($tags_list) {
	$tags = explode(",", $tags_list);
	$last_tag = end($tags);
	echo ("\t\t\t");
	foreach ($tags as $tag) {
		echo ("<a href=\"" . PHPSELF . "?tag=" . str_replace(" ", "_", trim($tag)) . "\">" . trim($tag) . "</a>");
		if (current($tags) != $last_tag) echo ", ";
		next($tags);
	}
	echo ("\n");
}

/* I was too lazy to write my own function, so.. thanks to admin \x40 uostas.net (http://php.net/manual/en/ref.array.php#73434)! */
function xd_array_rmval ($val, &$arr) {
	$i = array_search ($val,$arr);
	if ($i === false) return false;
	$arr = array_merge (array_slice ($arr, 0, $i), array_slice ($arr, $i+1));
	return true;
}

function xd_inarray ($what, $where) {
	foreach ($where as $val) if ($val == $what) return true;
	return false;
}

function xd_rm_excluded_tags ($excluded_tags, $filename) {
	foreach ($excluded_tags as $excluded_tag) {
		if (file_exists(META_DIR . META_TAGS_DIR . trim($excluded_tag) . ".php")) {
			include (META_DIR . META_TAGS_DIR . trim($excluded_tag) . ".php");
			xd_array_rmval (str_replace(ROOT_DIR, "", $filename), $_tagged_files);
			if (count($_tagged_files) > 0) {
				$tag_file_content = "<?php\n\$_tagged_files = " . var_export($_tagged_files, true) . ";\n?>";
				xd_file_put_content (META_DIR . META_TAGS_DIR . trim($excluded_tag) . ".php", $tag_file_content);
			/* Delete unused tag file. */
			} else unlink (META_DIR . META_TAGS_DIR . trim($excluded_tag) . ".php");
		}
	}
	return true;
}

function xd_edit_tags ($filename, $tags) {

	/* Set the name of the meta file. */
	$meta_file = xd_metafile_of ($filename);
	/* Make array of the tags. */
	$tags = str_replace(", ", ",", $tags);
	$edited_tags = explode(",", $tags);

	/* First update the tag file. This is the file, named as the tagname with a "php" extension, where the tagged files are stored in an array. */
	foreach ($edited_tags as $edited_tag) {
		if (!file_exists(META_DIR . META_TAGS_DIR . trim($edited_tag) . ".php")) {
			if (!file_exists(META_DIR . META_TAGS_DIR)) xd_mkdirp (META_DIR . META_TAGS_DIR);
			$_tagged_files = array();
			$tag_file_content = "<?php\n\$_tagged_files = " . var_export($_tagged_files, true) . ";\n?>";
			xd_file_put_content (META_DIR . META_TAGS_DIR . trim($edited_tag) . ".php", $tag_file_content);
		}
		include (META_DIR . META_TAGS_DIR . trim($edited_tag) . ".php");
		if (!in_array(str_replace(ROOT_DIR, "", $filename), $_tagged_files)) {
			$_tagged_files[] = str_replace(ROOT_DIR, "", $filename);
			$tag_file_content = "<?php\n\$_tagged_files = " . var_export($_tagged_files, true) . ";\n?>";
			xd_file_put_content (META_DIR . META_TAGS_DIR . trim($edited_tag) . ".php", $tag_file_content);
		}
	}

	$excluded_tags = array();

	/* Now update the filename-metafile with the new tags. */
	if (file_exists($meta_file)) {
		include ($meta_file);
		$_tags = str_replace(", ", ",", $_tags);
		$old_tags = explode(",", $_tags);

		/* Create an array containing the unset tags. */	
		foreach ($old_tags as $old_tag) if (!xd_inarray(trim($old_tag), $edited_tags)) $excluded_tags[] = trim($old_tag);
		$_tags = $tags;
	} else {
		$_description = "";
		$_tags = $tags;
		$_categories = "";
	}

	/* Set the new content of the metafile. */
	$meta_file_content = 
'<?php
' . '$' . '_description = "' . $_description . '";
' . '$' . '_tags = "' . $_tags . '";
' . '$' . '_categories = "' . $_categories . '";
' . '?>';

	/* Write the new content to the metafile at last. */
	xd_file_put_content ($meta_file, $meta_file_content);

	/* Delete unset tags. */
	if (count($excluded_tags) > 0) xd_rm_excluded_tags ($excluded_tags, $filename) ;

	return true;
}

function xd_change_settings ($what, $post_array) {
	$file_string = file_get_contents(basename(PHPSELF));
	$string_to_parse = strstr($file_string, "\n  /*********************************************/\n /* Edit below if you know what you're doing! */\n/*********************************************/\n");

	$xd_username = USERNAME;
	$xd_include_categories_as_tags = INCLUDE_CATEGORIES_AS_TAGS;

	if ($what == "labels") {
		$xd_label_info = $post_array['edit_label_info'];
		$xd_label_edit = $post_array['edit_label_edit'];
		$xd_label_move = $post_array['edit_label_move'];
		$xd_label_rename = $post_array['edit_label_rename'];
		$xd_label_delete = $post_array['edit_label_delete'];
		$xd_label_up_dir = $post_array['edit_label_up_dir'];
		$xd_label_add_tags = $post_array['edit_label_add_tags'];
		$xd_label_add_description = $post_array['edit_label_add_description'];
	} else {
		$xd_label_info = LABEL_INFO;
		$xd_label_edit = LABEL_EDIT;
		$xd_label_move = LABEL_MOVE;
		$xd_label_rename = LABEL_RENAME;
		$xd_label_delete = LABEL_DELETE;
		$xd_label_up_dir = LABEL_UP_DIR;
		$xd_label_add_tags = LABEL_ADD_TAGS;
		$xd_label_add_description = LABEL_ADD_DESCRIPTION;
	}

	if ($what == "pass") $xd_password = md5($post_array['new_password1']);
	else $xd_password = PASSWORD;

	if ($what == "prefs") {
		$xd_root_dir = $post_array['edit_root_dir'];
		$xd_meta_dir = $post_array['edit_meta_dir'];
		$xd_editable = $post_array['edit_editable'];
		$xd_title = $post_array['edit_title'];
		$xd_date_format = $post_array['edit_date_format'];
		$xd_img_extensions = $post_array['edit_img_extensions'];
		$xd_img_width = $post_array['edit_img_width'];
	} else {
		$xd_root_dir = ROOT_DIR;
		$xd_meta_dir = META_DIR;
		$xd_editable = EDITABLE;
		$xd_title = TITLE;
		$xd_date_format = DATE_FORMAT;
		$xd_img_extensions = IMG_EXTENSIONS;
		$xd_img_width = IMG_WIDTH;
	}

	$content_parse  =
'<?php
/* Define login data. */
define("USERNAME", "' . USERNAME . '");			/* IMPORTANT! This is the username used for login. Set to a prefered by you! */
define("PASSWORD", "' . $xd_password . '");

/* Define important directory and file names! Please use a trailing slash ("/") for all directory names! */
define("ROOT_DIR", "' . $xd_root_dir . '");				/* IMPORTANT! This is the directory where your files are stored. Set to a prefered by you! */
define("META_DIR", "' . $xd_meta_dir . '");				/* This is the directory which is used for storing all "meta data". */
define("META_ROOT_DIR", "' . META_ROOT_DIR . '");			/* This is a directory inside the META_DIR mirroring the ROOT_DIR with the "meta data". */
define("META_TAGS_DIR", "' . META_TAGS_DIR . '");			/* This is a directory inside the META_DIR used to organize the tags. */
define("EDITABLE", "' . $xd_editable . '");		/* Define the extensions of the files which are allowed for editing. */
define("IMG_EXTENSIONS", "' . IMG_EXTENSIONS . '");	/* Define extensions for image files. */
define("IMG_WIDTH", "' . $xd_img_width . '");				/* Define the width a picture should be previewed with. */

/* Define preferencies for title and date format. */
define("TITLE", "' . $xd_title . '");				/* Define the title to be displayed. */
define("DATE_FORMAT", "' . $xd_date_format . '");			/* Set your prefered date format. Please refer to http://php.net/date for details. */

/* Define labels. */
define("LABEL_INFO", "' . $xd_label_info . '");				/* This is the label for the "info/edit(tags/description)" link. */
define("LABEL_EDIT", "' . $xd_label_edit . '");				/* This is the label for the "edit" link. */
define("LABEL_MOVE", "' . $xd_label_move . '");				/* This is the label for the "move" link. */
define("LABEL_RENAME", "' . $xd_label_rename . '");			/* This is the label for the "rename" link. */
define("LABEL_DELETE", "' . $xd_label_delete . '");			/* This is the label for the "delete" link. */
define("LABEL_UP_DIR", "' . $xd_label_up_dir . '");	/* This is used as a label for the directory above the current one. */
define("LABEL_ADD_TAGS", "' . $xd_label_add_tags . '");			/* This is the label for the link displayed if no tags available. Comment out if not wished. */
define("LABEL_ADD_DESCRIPTION", "' . $xd_label_add_description . '");	/* This is the label for the link displayed if no description available. Comment out if not wished. */

/* Define preferencies for the organization criteria. */
define("INCLUDE_CATEGORIES_AS_TAGS", ' . INCLUDE_CATEGORIES_AS_TAGS . ');		/* NOT IMPLEMENTED YET! Define if the categories should be set as tags also. (1="TRUE" or 0="FALSE") */
' . $string_to_parse;

	return $content_parse;
}

/* Dirty solution when URL file-access is disabled in the server configuration. */
function xd_wget_system ($url, $target_dir, $target_name = '') {
	if (empty($target_name)) {
		$url_arr = parse_url($url);
		$target_name = $url_arr['path'];
	}
	$target = $target_dir . "/" . $target_name;
	if (file_exists($target)) $target = $target_dir . "/" . $target_name . "-downloaded_at-" . date("Ymd");
	system('wget -O ' . $target . ' ' . str_replace(' ', '%20', html_entity_decode($url)), $output);
	if ($output == 0) return true;
	else return false;
}

function xd_upload ($target_dir) {
	$k = 0;
	foreach ($_FILES['files_to_upload']['name'] as $file) {
		$separator = ($target_dir[strlen($target_dir)-1]=='/') ? '': '/';
		$target_path = $target_dir . $separator . $file;
		if (! move_uploaded_file ($_FILES['files_to_upload']['tmp_name'][$k], $target_path)) return false;
		xd_edit_tags($target_path, $_POST['tag']);
		$k++;
	}
	return true;

}
/* Functions end here. */

/* Where should we go after some action? More in the perticular action... */
$redirect = "http://{$_SERVER["HTTP_HOST"]}{$_SERVER["PHP_SELF"]}";

/* Actions start here. */
if (isset($_GET['edited'])) {	
	$filename = $_GET['edited'];
	if (strtolower($_REQUEST['submit']) != "cancel") {	
		$new_content = $_POST['editfile'];
		if (xd_file_put_content ($filename, $new_content)) $_SESSION['message'] = "\"" . $filename . "\"<br />was successfully changed.";
		else $_SESSION['message'] = "\"" . $filename . "\"<br />could not be changed.";
	} else $_SESSION['message'] = "\"" . str_replace(ROOT_DIR, "", $filename) . "\"<br />was left unchanged.";
	if (dirname($_GET['edited']) != str_replace("/", "", ROOT_DIR)) $subdir_url = "?msg&subdir=" . str_replace(ROOT_DIR, "", dirname($_GET['edited']));
	else $subdir_url = "?msg";
	header("Location:" . $redirect . $subdir_url);
	
} else if (isset($_GET['login'])) {
	if ($_REQUEST['username'] != USERNAME || md5($_REQUEST['password']) != PASSWORD) {
		$_SESSION['login'] = false;
		$_SESSION['message'] = "Login failed.";
	} else {
		$_SESSION['login'] = true;
		$_SESSION['message'] = "Successfully logged in.<br />Welcome, " . USERNAME . "!";
	}
	header("Location:" . $redirect . "?msg");

} else if (isset($_GET['logout'])) {
	xd_logout();
	session_start();
	$_SESSION['login'] = "false";
	header("Location:" . $redirect);

} else if (isset($_GET['settings'])) {
	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<div class=\"titlesettings\">\n");
	echo ("\t\t<a href=\"#\" onclick=\"\$toggle('settings0'); return false\">Change password</a>\n");
	echo ("\t</div>\n");
	echo ("\t<div style=\"overflow: hidden; display: block; height: 0px;\" id=\"settings0\">\n");
	echo ("\t\t<div class=\"settingstext\">\n");
	echo ("\t\t<form method=\"post\" action=\"" . PHPSELF . "?change=pass\">\n");
	echo ("\t\t<table>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\tUsername:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t" . USERNAME . "\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\tOld password:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"password\" name=\"old_password\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\tNew password:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"password\" name=\"new_password1\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\tNew password (retype):\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"password\" name=\"new_password2\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td colspan=\"2\" style=\"text-align: center;\">\n");
	echo ("\t\t\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"change\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t</table>\n");
	echo ("\t\t</form>\n");
	echo ("\t\t<br />\n");
	echo ("\t\t</div>\n");
	echo ("\t</div>\n");
	echo ("</div>\n");

	echo ("<hr class=\"line\" />\n");

	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<div class=\"titlesettings\">\n");
	echo ("\t\t<a href=\"#\" onclick=\"\$toggle('settings1'); return false\">Change preferences</a>\n");
	echo ("\t</div>\n");
	echo ("\t<div style=\"overflow: hidden; display: block; height: 0px;\" id=\"settings1\">\n");
	echo ("\t\t<div class=\"settingstext\">\n");
	echo ("\t\t<form method=\"post\" action=\"" . PHPSELF . "?change=prefs\">\n");
	echo ("\t\t<table>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"IMPORTANT! This is the directory where your files are stored!\">\"Root\" directory</acronym>:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_root_dir\" value=\"" . ROOT_DIR . "\" >\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"This is the directory for storing all 'meta data'.\">\"Meta\" directory</acronym>:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_meta_dir\" value=\"" . META_DIR . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"Extensions of the files which are allowed for editing.\">Extensions of files allowed to be edited</acronym>:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_editable\" value=\"" . EDITABLE . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"Define the title to be displayed.\">Title</acronym>:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_title\" value=\"" . TITLE . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"Set your prefered date format. See http://php.net/date for details.\">Date format</acronym>:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_date_format\" value=\"" . DATE_FORMAT . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"Define extensions for image files.\">Images extensions</acronym>:<br /><small>(use a space to separate)</small>\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_img_extensions\" value=\"" . IMG_EXTENSIONS . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<acronym title=\"Define the width a picture should be previewed with.\">Image preview width</acronym>:<br /><small>(in pixel)</small>\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_img_width\" value=\"" . IMG_WIDTH . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td colspan=\"2\" style=\"text-align: center;\">\n");
	echo ("\t\t\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"change\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t</table>\n");
	echo ("\t\t</form>\n");
	echo ("\t\t</div>\n");
	echo ("\t</div>\n");
	echo ("</div>\n");

	echo ("<hr class=\"line\" />\n");

	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<div class=\"titlesettings\">\n");
	echo ("\t\t<a href=\"#\" onclick=\"\$toggle('settings2'); return false\">Change labels</a>\n");
	echo ("\t</div>\n");
	echo ("\t<div style=\"overflow: hidden; display: block; height: 0px;\" id=\"settings2\">\n");
	echo ("\t\t<div class=\"settingstext\">\n");
	echo ("\t\t<form method=\"post\" action=\"" . PHPSELF . "?change=labels\">\n");
	echo ("\t\t<table>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Info\" label:\n");
		/* This is the label for the "info/edit(tags/description)" link. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_info\" value=\"" . LABEL_INFO . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Edit\" label:\n");
		/* This is the label for the "edit" link. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_edit\" value=\"" . LABEL_EDIT . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Move\" label:\n");
		/* This is the label for the "move" link. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_move\" value=\"" . LABEL_MOVE . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Rename\" label:\n");
		/* This is the label for the "rename" link. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_rename\" value=\"" . LABEL_RENAME . "\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Delete\" label:\n");
		/* This is the label for the "delete" link. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_delete\" value=\"" . LABEL_DELETE . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Parent directory\" label:\n");
		/* This is used as a label for the directory above the current one. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_up_dir\" value=\"" . LABEL_UP_DIR . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Add tags\" label:\n");
		/* This is the label for the link displayed if no tags available. Comment out if not wished. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_add_tags\" value=\"" . LABEL_ADD_TAGS . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t\"Add description\" label:\n");
		/* This is the label for the link displayed if no description available. Comment out if not wished. */
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"edit_label_add_description\" value=\"" . LABEL_ADD_DESCRIPTION . "\">\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td colspan=\"2\" style=\"text-align: center;\">\n");
	echo ("\t\t\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"change\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t</table>\n");
	echo ("\t\t<br />\n");
	echo ("\t\t<br />\n");
	echo ("\t\t</form>\n");
	echo ("\t\t</div>\n");
	echo ("\t</div>\n");
	echo ("</div>\n");
	exit;

} else if (isset($_GET['change'])) {
	if ($_GET['change'] == "pass") {
		if (md5($_POST['old_password']) != PASSWORD) {
			$_SESSION['message'] = "ERROR: Wrong password!<br />Please identify yourself with the old password.";
			header("Location:" . $redirect . "?msg");
			exit;
		} else if ($_POST['new_password1'] != $_POST['new_password2']) {
			$_SESSION['message'] = "ERROR: New password incorrect retyped!";
			header("Location:" . $redirect . "?msg");
			exit;
		}
	}
	if (xd_file_put_content (basename(PHPSELF), xd_change_settings($_GET['change'], $_POST))) { $_SESSION['message'] = "Successfully edited the settings."; }
	else { $_SESSION['message'] = "ERROR editing the settings!"; }
	header("Location:" . $redirect . "?msg");

} else if (isset($_GET['info'])) {
	echo xd_create_info($_GET['info']);
	exit;

} else if (isset($_GET['create_in'])) {
	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<div class=\"titlesettings\">\n");
	echo ("\t\t<a href=\"#\" onclick=\"\$toggle('create_file'); return false\" title=\"Create a file\">Create file</a>\n");
	echo ("\t</div>\n");
	echo ("\t<div style=\"overflow: hidden; display: block; height: 0px;\" id=\"create_file\">\n");
	echo ("\t\t<br />\n");
	echo ("\t\t<form method=\"post\" action=\"" . PHPSELF . "?touch\">\n");
	echo ("\t\t<input class=\"input\" type=\"text\" name=\"create\" />\n");
	echo ("\t\t<input type=\"hidden\" name=\"pwd\" value=\"" . str_replace (ROOT_DIR, "", $_GET['create_in']) . "\" />\n");
	echo ("\t\t<input class=\"button\" type=\"submit\" value=\"create a file\">\n");
	echo ("\t\t</form>\n");
	echo ("</div>\n");
	echo ("<hr class=\"line\" />\n");
	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<div class=\"titlesettings\">\n");
	echo ("\t\t<a href=\"#\" onclick=\"\$toggle('create_directory'); return false\" title=\"Create a directory\">Create directory</a>\n");
	echo ("\t</div>\n");
	echo ("\t<div style=\"overflow: hidden; display: block; height: 0px;\" id=\"create_directory\">\n");
	echo ("\t\t<br />\n");
	echo ("\t\t<form method=\"post\" action=\"" . PHPSELF . "?mkdir\">\n");
	echo ("\t\t<input class=\"input\" type=\"text\" name=\"create\" />\n");
	echo ("\t\t<input type=\"hidden\" name=\"pwd\" value=\"" . str_replace (ROOT_DIR, "", $_GET['create_in']) . "\" />\n");
	echo ("\t\t<input class=\"button\" type=\"submit\" value=\"create a directory\">\n");
	echo ("\t\t</form>\n");
	echo ("\t</div>\n");
	echo ("</div>\n");
	exit;

} else if (isset($_GET['download_to'])) {
	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<form method=\"post\" action=\"" . PHPSELF . "?wget\">\n");
	echo ("\t\t<table>\n");
	echo ("\t\t<tr class=\"tabletitle\">\n");
	echo ("\t\t\t<td colspan=\"2\" style=\"text-align: center;\">\n");
	echo ("\t\tDownload a file from the Web\n");
	echo ("\t\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t\t<td>\n");
	echo ("\t\t\t\t&nbsp;URL:\n");
	echo ("\t\t\t</td>\n");
	echo ("\t\t\t<td>\n");
	echo ("\t\t\t\t<input class=\"input\" type=\"text\" name=\"url\" />\n");
	echo ("\t\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"lightrow\">\n");
	echo ("\t\t\t<td>\n");
	echo ("\t\t\t\t&nbsp;Save as:\n");
	echo ("\t\t\t</td>\n");
	echo ("\t\t\t<td>\n");
	echo ("\t\t\t\t<input class=\"input\" type=\"text\" name=\"target_name\" />\n");
	echo ("\t\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t<tr class=\"darkrow\">\n");
	echo ("\t\t<td colspan=\"2\" style=\"text-align: center;\">\n");
	echo ("\t\t<input type=\"hidden\" name=\"pwd\" value=\"" . $_GET['download_to'] . "\" />\n");
	echo ("\t\t<input class=\"button\" type=\"submit\" value=\"download\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t\t</tr>\n");
	echo ("\t\t</table>\n");
	echo ("\t</form>\n");
	echo ("</div>\n");
	exit;

} else if (isset($_GET['wget'])) {
	if (xd_wget_system ($_POST['url'], $_POST['pwd'], $_POST['target_name'])) $_SESSION['message'] = "Download completed and<br />&nbsp;saved as: \"" . $_POST['target_name'] . "\".";
	else $_SESSION['message'] = "ERROR: The file could not be downloaded!";
	if ($_POST['pwd'] != ROOT_DIR) $subdir_url = "?msg&subdir=" . str_replace(ROOT_DIR, "", $_POST['pwd']);
	else $subdir_url = "?msg";
	header("Location:" . $redirect . $subdir_url);

} else if (isset($_GET['upload_to'])) {
	echo ("<div class=\"settingsblock\">\n");
	echo ("\t<form method=\"post\" enctype=\"multipart/form-data\" action=\"" . PHPSELF . "?upload\">\n");
	echo ("\t\t&nbsp;Select a file for upload:<br />\n");
	echo ("\t\t&nbsp;<small>(The server limit for maximal file size is <b>" . xd_max_upload_size () . "B</b>.)</small><br /><br />\n");
	// Hack by JuanCa
	// Revisa si tag esta activo
	echo ("\t\t<input type=\"hidden\" name=\"tag\" value=\"" . $_GET['tag'] . "\" />\n");
	// End of Hack
	echo ("\t\t<input class=\"input\" type=\"file\" name=\"files_to_upload[]\" id=\"attachment\" onchange=\"document.getElementById('moreUploadsLink').style.display = 'block';\" /><br />\n");
	echo ("\t\t<div id=\"moreUploads\"></div>\n");
	echo ("\t\t<div id=\"moreUploadsLink\" style=\"display:none;\"><br /><a href=\"javascript:addFileInput();\">add file</a><br /></div>\n");
	echo ("\t\t<input type=\"hidden\" name=\"pwd\" value=\"" . $_GET['upload_to'] . "\" />\n");
	echo ("\t\t<br /><input class=\"button\" type=\"submit\" value=\"upload\" />\n");
	echo ("\t</form>\n");
	echo ("</div>\n");
	exit;

} else if (isset($_GET['upload'])) {
	if (xd_upload ($_POST['pwd'])) $_SESSION['message'] = "Upload completed.";
	else $_SESSION['message'] = "ERROR: The file(s) could not be uploaded!";
	if ($_POST['pwd'] != ROOT_DIR) $subdir_url = "?tag=".$_POST['tag']."&subdir=" . str_replace(ROOT_DIR, "", $_POST['pwd'])."&msg";
	else $subdir_url = "?tag=".$_POST['tag']."&msg";
	header("Location:" . $redirect . $subdir_url);
	if (isset($_POST['tag'])) {
		include (META_DIR . META_TAGS_DIR . $_POST['tag'] . ".php");
		if (isset($_tagged_files))
			$_file_list = $_tagged_files;
		else
			$_file_list = '';
	}

} else if (isset($_GET['rename'])) {
	echo ("\t<form action=\"" . PHPSELF . "?renamed=" . $_GET['rename'] . "\" method=\"post\">\n");
	echo ("\tRename:<br /><br />\"" . basename($_GET['rename']) . "\" to \n");
	echo ("\t\t<input type=\"hidden\" name=\"pwd\" value=\"" . dirname($_GET['rename']) . "\" />\n");
	echo ("\t\t<input class=\"input\" type=\"text\" name=\"new_name\" value=\"" . basename($_GET['rename']) . "\"/><br /><br />\n");
	echo ("\t\t<input class=\"button\" type=\"submit\" value=\"rename\">\n");
	echo ("\t</form>\n");
	exit;

} else if (isset($_GET['renamed'])) {
	if (@rename($_GET['renamed'], dirname($_GET['renamed']) . "/" . $_POST['new_name'])) $_SESSION['message'] = "\"" . $_GET['renamed'] . "\"<br />&nbsp;&nbsp;was successfully renamed to<br />\"" . $_POST['new_name'] . "\"";
	else $_SESSION['message'] = "\"" . $_GET['renamed'] . "\"<br />&nbsp;&nbsp;could not be renamed to<br />" . $_POST['new_name'] . "\"";
	if (dirname($_GET['renamed']) != str_replace("/", "", ROOT_DIR)) $subdir_url = "?msg&subdir=" . str_replace(ROOT_DIR, "", dirname($_GET['renamed']));
	else $subdir_url = "?msg";
	header("Location:" . $redirect . $subdir_url);

} else if (isset($_GET['move'])) {
	echo ("\tMove<br /><br />\"" . str_replace(ROOT_DIR, "/", $_GET['move']) . "\" to \n");
	echo ("\t<form action=\"" . PHPSELF . "?moved=" . $_GET['move'] . "\" method=\"post\">\n");
	echo ("\t\t<select class=\"select\" name=\"target_dir\">\n");
	echo ("\t\t\t<option value=\"/\">/ (root directory)</option>\n");
	foreach (xd_getdirs(ROOT_DIR) as $dir) echo ("\t\t\t<option value=\"" . $dir . "\" class=\"select\">" . $dir . "</option>\n");
	echo ("\t\t</select>\n");
	echo ("\t\t\t<input type=\"hidden\" name=\"pwd\" value=\"" . dirname($_GET['move']) . "\" /><br /><br />\n");
	echo ("\t\t\t<input class=\"button\" type=\"submit\" value=\"move\">\n");
	echo ("\t\t</form>\n");
	exit;

} else if (isset($_GET['moved'])) {
	if (@rename($_GET['moved'], str_replace("/", "", ROOT_DIR) . $_POST['target_dir'] . "/" . basename($_GET['moved']))) $_SESSION['message'] = "\"" . str_replace(ROOT_DIR, "", $_GET['moved']) . "\"<br />&nbsp;&nbsp;was successfully moved to<br />\"" . str_replace(ROOT_DIR, "", $_POST['target_dir']) . "\".";
	else $_SESSION['message'] = "ERROR: \"" . str_replace(ROOT_DIR, "", $_GET['moved']) . "\"<br />&nbsp;&nbsp;could not be moved to<br />" . str_replace(ROOT_DIR, "", $_POST['target_dir']) . "\"!";
	if (dirname($_GET['moved']) != str_replace("/", "", ROOT_DIR)) $subdir_url = "?msg&subdir=" . str_replace(ROOT_DIR, "", dirname($_GET['moved']));
	else $subdir_url = "?msg";
	header("Location:" . $redirect . $subdir_url);

} else if (isset($_GET['delete'])) {

	if (file_exists(xd_metafile_of($_GET['delete']))) {
		include (xd_metafile_of($_GET['delete']));
		$tags = str_replace(", ", ",", $_tags);
		$excluded_tags = explode(",", $tags);
		xd_rm_excluded_tags ($excluded_tags, $_GET['delete']);
		xd_rmrf(xd_metafile_of($_GET['delete']));
	}
	if (xd_rmrf($_GET['delete'])) $_SESSION['message'] = "\"" . str_replace(ROOT_DIR, "", $_GET['delete']) . "\"<br />was successfully deleted.";
	else $_SESSION['message'] = "ERROR: \"" . str_replace(ROOT_DIR, "", $_GET['delete']) . "\"<br />could not be deleted.";

	if (dirname($_GET['delete']) != str_replace("/", "", ROOT_DIR)) $subdir_url = "?tag=".$_GET['tag']."&subdir=" . str_replace(ROOT_DIR, "", dirname($_GET['delete']))."&msg";
	else $subdir_url = "?tag=".$_GET['tag']."&msg";
	//echo "Location:" . $redirect . $subdir_url;
	header("Location:" . $redirect . $subdir_url);
	if (isset($_GET['tag'])) {
		include (META_DIR . META_TAGS_DIR . $_GET['tag'] . ".php");
		if (isset($_tagged_files))
			$_file_list = $_tagged_files;
		else
			$_file_list = '';
	}

} else if (isset($_GET['tag'])) {
	include (META_DIR . META_TAGS_DIR . $_GET['tag'] . ".php");
	// Hack by JuanCa
	// Fuerza la definicion de $_file_list
	if (isset($_tagged_files))
		$_file_list = $_tagged_files;
	else
		$_file_list = '';
	// Fin del Hack

} else if (isset($_GET['edited_tags'])) {
	if (xd_edit_tags($_GET['edited_tags'], $_POST['edit_tags'])) { $_SESSION['message'] = "Successfully edited the tags of<br />\"" . basename($_GET['edited_tags']) . "\"."; }
	else { $_SESSION['message'] = "ERROR: The tags of<br />\"" . basename($_GET['edited_tags']) . "\" could not be edited!"; }

	if (dirname($_GET['edited_tags']) != str_replace("/", "", ROOT_DIR)) { $subdir_url = "?msg&subdir=" . str_replace(ROOT_DIR, "", dirname($_GET['edited_tags'])); }
	else { $subdir_url = "?msg"; }

	header("Location:" . $redirect . $subdir_url);

} else if (isset($_GET['edited_description'])) {
	$meta_file = META_DIR . META_ROOT_DIR . str_replace(ROOT_DIR, "", $_GET['edited_description']) . "-xd_meta.php";

	if (file_exists($meta_file)) { include ($meta_file); }
	if (!isset($_tags)) { $_tags = ""; }
	if (!isset($_categories)) { $_categories = ""; }
	$_description = $_POST['edit_description'];

	$meta_file_content = "<?php\n\$_description = \"" . $_description . "\";\n\$_tags = \"" . $_tags . "\";\n\$_categories = \"" . $_categories . "\";\n?>";

	if (xd_file_put_content ($meta_file, $meta_file_content)) { $_SESSION['message'] = "Successfully edited the description of<br />\"" . basename($_GET['edited_description']) . "\"."; }
	else { $_SESSION['message'] = "ERROR: The description of<br />\"" . basename($_GET['edited_description']) . "\" could not be edited!"; }

	if (dirname($_GET['edited_description']) != str_replace("/", "", ROOT_DIR)) { $subdir_url = "?msg&subdir=" . str_replace(ROOT_DIR, "", dirname($_GET['edited_description'])); }
	else { $subdir_url = "?msg"; }

	header("Location:" . $redirect . $subdir_url);

} else if (isset($_GET['touch'])) {
	if (!empty($_POST['pwd'])) $subdir_url = "?msg&subdir=" . $_POST['pwd'];
	else $subdir_url = "?msg";
	if (touch(ROOT_DIR . "/" . $_POST['pwd'] . "/" . $_POST['create'])) { $_SESSION['message'] = "\tThe file \"" . $_POST['create'] . "\"<br />was successfully created."; }
	else { $_SESSION['message'] = "ERROR: The file<br />\"" . $_POST['create'] . "\" could not be created!"; }
	header("Location:" . $redirect . $subdir_url);

} else if (isset($_GET['mkdir'])) {
	if (!empty($_POST['pwd'])) { $subdir_url = "?msg&subdir=" . $_POST['pwd']; }
	else { $subdir_url = "?msg"; }
	if (mkdir(ROOT_DIR . "/" . $_POST['pwd'] . "/" . $_POST['create'])) { $_SESSION['message'] = "\tThe directory \"" . $_POST['create'] . "\"<br />was successfully created."; }
	else { $_SESSION['message'] = "ERROR: The directory<br />\"" . $_POST['create'] . "\" could not be created!"; }
	header("Location:" . $redirect . $subdir_url);
}
/* Actions end here. */

/* Define some style. Please send me some changes. I would then create a "styles" link in http://xoda.org. */
$_style ="
	body {
		/*background:	#344556;*/
	}
	
	.boxed {
		margin:		0px;
		padding:	0px;
		width:		98%;
		height:		378px;
	}
	
	#top {
		position:	absolute;
		top:		0px;
		left:		0px;
		right:		400px;
		height:		30px;
		background:	#fff;
		font:		normal 10px Helvetica,Arial;
		color:		#9aabbc;
		padding:	0px;
		text-align:	left;
		/*display:	none;*/
	}

	#navbar {
		position:	absolute;
		background:	#ffffff;
		/*border-top:	1px solid #677889;*/
		/*border-bottom:	1px solid #677889;*/
		border-color:white #677889 gray gray;
		border-style:dotted;
		border-width:1px;
		text-align:	right;
		top:		0px;	 /*100px;*/
		/*left:		270px;	/*30px;*/
		right:		20px;	/*30px;*/
		height:		17px;
		padding:	5px 0px 5px 0px;
	}

	#navbar li {
		display:	inline;
		list-style-type:none;
		margin:		0px;
		color:		#cddeef;
		padding:	0px;
	}

	#navbar ul {
		margin:		0px;
		padding:	0px 0px 0px 10px;
	}

	#navbar ul li a {
		font:		normal 10pt Helvetica,Arial;
		color:		#ff9933;	/*#cddeef;*/
		padding:	7px 10px 5px 10px;
		margin:		0px;
		text-decoration:none;
		text-transform:	uppercase;
		font-weight:	bold;
		border-bottom:	0px solid #cccccc;
	}

	#navbar ul li a:hover {
		background:	#cddeef;
		color:		#455667;
		text-decoration:none;
	}

	#overlay {
		position: absolute;
		z-index:100;
		top: 0px;
		left: 0px;
		width:	100%;
		height:	100%;
		background-color:#000;
		filter:alpha(opacity=60);
		-moz-opacity: 0.6;
		opacity: 0.6;
	}

	#main {
		position:	absolute;
		top:		20px;	/*130px;*/
		height:		370px;	/*80%;*/
		bottom:		15px;	/*30px;*/
		left:		1px;	/*30px;*/
		right:		1px;	/*30px;*/
		/*background:	#566778;*/
		font:		normal 10px Helvetica,Arial;
		color:		#666;	/*#abbccd;*/
		border-color:	white gray white gray;
		border-style:	solid;
		border-width:	0px;
		width:		99%;
	}

	#create {
		position:	absolute;
		top:		0;
		left:		0;
		text-align:	left;
		background:	#455667;
		font:		normal 10pt Helvetica,Arial;
		color:		#78899a;
	}

	a {
		color:			#9aabbc;
		text-decoration:	none;
		border-bottom:		1px dotted #9aabbc;
	}

	a:hover {
		color:			#bccdde;
		text-decoration:	none;
		border-bottom:		1px dotted #ff6743;
	}

	.table {
		position:	relative;
		border-color:	gray gray gray white;
		border-style:	dashed;
		border-width:	1px;
		left:		-1px;
		background:	white;	/*#344556;*/
		top:		20px;
		padding:	5px;
		font:		normal 10px Helvetica,Arial;
		color:		gray;
	}

	.tabletitle {
		background:	#ddd;
		color:		#666;
		padding:	3px;
		font-weight:	bold;
	}

	.tablehead {
		background:	#344556;
	}

	.lightrow {
		background:	#FFFFEE;
		padding:	5px;
	}

	.darkrow {
		background:	#EEFFEE;
		padding:	5px;
	}

	.descr {
		font:		italic 10px Arial,Helvetica;
		padding:	5px;
	}

	.tags {
		font:		normal 10px Arial,Helvetica;
		padding:	5px;
	}

	.lightrow a, .lightrow a:hover, .darkrow a, .darkrow a:hover, .descr a, .descr a:hover {
		text-decoration:	none;
		border:			0px;
	}

	.highlight {
		position:	absolute;
		background:	#344556;
		border-top:	1px solid #abbccd;
		border-right:	1px solid #344556;
		border-bottom:	1px solid #abbccd;
		border-left:	1px solid #abbccd;
		top:		0px;
		right:		0px;
		font:		normal 8pt Helvetica,Arial;
		text-align:	left;
		width:		300px;
		color:		#ff6743;
		padding-top:	10px;
		padding-right:	10px;
		padding-bottom:	0;
		padding-left:	10px;
	}

	.highlight .status_title {
		background:	#455667;
		margin:		-11px -10px 5px -11px;
		border-top:	1px solid #abbccd;
		border-right:	1px solid #abbccd;
		border-bottom:	1px solid #abbccd;
		border-left:	1px solid #455667;
		padding:	3px;
		font:		bold 10pt Helvetica,Arial;
		color:		#abbccd;
	}

	.edit {
		border-top:	1px solid #abbccd;
		border-bottom:	1px solid #abbccd;
		border-left:	none;
		border-right:	none;
		width:		100%;
		padding:	0px;
		background:	#122334;
		font:		normal 10pt Helvetica,Arial;
		color:		#abbccd;
	}

	.button {
		border:		0px;
		background:	#455667;
		color:		#abbccd;
	}

	.input, .select {
		border:		0px;
		background:	#cddeef;
		color:		#233445;
	}

	.select {
		font:		normal 8pt Helvetica,Arial;
	}

	.loader {
		color:		#cddeef;
	}

	hr.line {
		border:			0;
		width:			100%;
		background-color:	#abbccd;
		color:			#abbccd;
		height:			1px;
	}

	#infobox {
		position:	absolute;
		background:	white;	/*#344556;*/
		width:		300px;
		color:		#9aabbc;
		text-align:	left;
		border-color:	gray white gray gray;
		border-style:	dotted;
		border-width:	1px;
		top:		20px;
		right:		-1px;
		left:		auto;
		padding:	5px;
		height:		290px;
		font:		normal 10px Helvetica,Arial;
	}

	#infobox .boxed {
		margin:		0px;
		padding:	0px;
		height:		auto;
	}

	#infobox .boxed table{
		font-size:	10px;
	}

	.settingsblock .titlesettings {
		display:	block;
		padding-left:	10px;
		padding-top:	2px;
		padding-bottom:	2px;
		border: 	none;
	}

	.settingsblock a {
		font-weight:	bold;
		color:		#abbccd;
		text-decoration:none;
		border:		none;
	}

	.settingsblock .settingstext {
		font-size:	10pt;
		color:		#78899a;
		padding:	2px;
	}

	#create_file, #create_directory {
		display:	none;
		margin-left:	-10px;
	}";

/* Check for important directories and create them if necessary. */
xd_init ();

/* Hack by JuanCa */
$_SESSION['login'] = true;
/* End of Hack by JuanCa */

/* Start the HTML at least! :) */
echo ("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
echo ("<html>\n");
echo ("<head>\n");
echo ("\t<title>" . TITLE . "</title>\n");
echo ("\t<meta http-equiv=\"content-type\" content=\"text/css; charset=utf-8\" />\n");
/*
	Now include the SimpleJS library (http://simplejs.bleebot.com/) for the AJAX stuph.
	The compression was made with the C-version of the excellent "JSMin" (http://www.crockford.com/javascript/jsmin.html) by
	Douglas Crockford (http://www.crockford.com/). Thanks Douglas! :)

	Special thanks to Christophe Lefevre, autor of SimpleJS for this excellent library and the english language used in the documentation! :)

	#1: simple.js
	#2: simpleajax.js
	#3: simpleslish.js

	#4: This is a function to add more file upload fields taken from http://www.petefreitag.com/item/587.cfm and modified by me. Thanks Pete! :)
*/
?>
<!--Scripts-->
<?
echo ("\t<style type=\"text/css\">" . $_style . "\n\t</style>\n");
echo ("\t<script type=\"text/javascript\">\n");
echo ("\t\tfunction checkDelete() {\n");
echo ("\t\t\tvar value = confirm(\"Do you really want to delete this?\");\n");
echo ("\t\t\tif (value == true) {\n");
echo ("\t\t\t\treturn true;\n");
echo ("\t\t\t} else {\n");
echo ("\t\t\t\treturn false;\n");
echo ("\t\t\t}\n");
echo ("\t\t}\n");
echo ("\t</script>\n");
echo ("</head>\n");
if (isset($_GET['msg']) || isset($_GET['edit'])) echo ("<body onload=\"\$blinddown('status', 900)\">\n");
else echo ("<body>\n");
echo ("<div id=\"top\">\n");
//echo ("\t<a href=\"" . PHPSELF . "\" title=\"" . TITLE . "\">" . $_top_content . "</a>\n");
if (isset($_GET['msg'])) echo ("\t<div id=\"status\" class=\"highlight\"><div class=\"status_title\">Status message:</div>" . $_SESSION['message'] . "</div>\n");

if (!$_SESSION['login']) {
	echo ("\t</div>\n");
	echo ("\t<div id=\"main\">\n");
	echo ("\t<form method=\"post\" action=\"" . PHPSELF . "?login\">\n");
	echo ("\t<table class=\"table\">\n");
	echo ("\t<tr class=\"tabletitle\">\n");
	echo ("\t\t<td colspan=\"2\">\n");
	echo ("\t\t\t&nbsp;Login\n");
	echo ("\t\t</td>\n");
	echo ("\t</tr>\n");
	echo ("\t<tr>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\tUsername:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"text\" name=\"username\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t</tr>\n");
	echo ("\t<tr>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\tPassword:\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t<input class=\"input\" type=\"password\" name=\"password\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t</tr>\n");
	echo ("\t<tr>\n");
	echo ("\t\t<td colspan=\"2\">\n");
	echo ("\t\t\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"login\" />\n");
	echo ("\t\t</td>\n");
	echo ("\t</tr>\n");
	echo ("\t</table>\n");
	echo ("\t</form>\n");
	echo ("</div>\n");
	echo ("</body>\n");
	echo ("</html>\n");
	exit;
}

if (isset($_GET['edit'])) {
	$filename = $_GET['edit'];
	echo ("\t<div id=\"status\" style=\"display:none;\" class=\"highlight\"><div class=\"status_title\">Edit file:</div>\"" . str_replace(ROOT_DIR, "", $filename) . "\"</div>\n");
	echo ("</div>\n");
	echo ("<div id=\"main\">\n");
	echo ("\t<form method=\"post\" action=\"" . PHPSELF . "?edited=" . $filename . "\">\n");
	echo ("\t<textarea class=\"edit\" style=\"height: 500px;\" name=\"editfile\">" . htmlentities(file_get_contents($filename)) . "</textarea>\n");
	echo ("\t<br />\n");
	echo ("\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"done\">\n");
	echo ("\t<input class=\"button\" type=\"submit\" name=\"submit\" value=\"cancel\">\n");
	echo ("\t</form>\n");
} else {
	echo ("</div>\n");
		echo ("<div id=\"navbar\">\n");
		echo ("\t<ul>\n");
		echo ("\t\t<li><a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?upload_to=" . xd_pwd() . "&tag=".$_GET['tag']."', 'false'); return false\" title=\"Upload file(s) to this directory \">Upload</a></li>\n");
	if ($acceso_usuario == 'Administrator') {
		echo ("\t\t<li><a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?download_to=" . xd_pwd() . "', 'false'); return false\" title=\"Download a file from the web\">Download</a></li>\n");
		echo ("\t\t<li><a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?create_in=" . xd_pwd() . "', 'false'); return false\" title=\"Create a file or directory\">Create</a></li>\n");
		echo ("\t\t<li>|</li>\n");
		echo ("\t\t<li><a href=\"#\" onclick=\"\$ajaxreplace('infobox','" . PHPSELF . "?settings', 'false'); return false\" title=\"Edit settings\">Settings</a></li>\n");
		//echo ("\t\t<li><a href=\"" . PHPSELF . "?logout\" title=\"Logout\">Logout</a></li>\n");
	}
		echo ("\t</ul>\n");
		echo ("</div>\n");
	echo ("<div id=\"overlay\" style=\"overflow: hidden; display: none; height: 0px;\"></div>\n");
	echo ("<div id=\"main\">\n");
	echo ("<table class=\"table\">\n");
	echo ("\t<tr class=\"tabletitle\">\n");
	echo ("\t\t<td colspan=\"2\">\n");
	echo ("\t\t\t&nbsp;Filename\n");
	echo ("\t\t</td>\n");
	echo ("\t\t<td>\n");
	echo ("\t\t\t&nbsp;Description&nbsp;\n");
	echo ("\t\t</td>\n");
	if ($acceso_usuario == 'Administrator') {
		echo ("\t\t<td>\n");
		echo ("\t\t\t&nbsp;Tags&nbsp;\n");
		echo ("\t\t</td>\n");
	}
	echo ("\t</tr>\n");

	if (isset ($_file_list)) {
		$files = $_file_list;
		unset ($_file_list);
	} else {
		$files = xd_get_dir_content (xd_pwd ());
		if (isset ($subdir)) xd_create_row ($subdir . "/..", " ");
	}
	xd_list_them ($files);
	echo ("</table>\n");

	echo ("\t<div id=\"infobox\">\n");
	echo ("\t\t<div class=\"tabletitle\">This is the \"info/edit\" box.</div>\n");
	echo ("\t<ul>\n");
	echo ("\t\t<li>Klick on \"" . LABEL_INFO . "\" of a file or directory to show further information about it.</li>\n");
	echo ("\t\t<li>Klick on the \"Upload\" link to show a form for uploading price's list from your computer to the current vendor .</li>\n");
	if ($acceso_usuario == 'Administrator') {
		echo ("\t\t<li>Klick on the \"Download\" link to show form for downloading a file from the web to the current directory.</li>\n");
		echo ("\t\t<li>Klick on the \"Create\" link to show links for creating file or directory.</li>\n");
		echo ("\t\t<li>Klick on the \"Settings\" link to change your password, set preferences and label names.</li>\n");
	}
	echo ("\t</ul>\n");
/*
	echo "GETS:<br />";
	print_r($_GET);
	echo "<br />POST:<br />";
	print_r($_POST);	
	echo "<br />Referer:<br />";
	echo $_SERVER['HTTP_REFERER'];	
	echo "<br />HTTP POST:<br />";
	echo $_SERVER["HTTP_HOST"];
	echo "<br />PHP SELF:<br />";
	echo $_SERVER["PHP_SELF"];
*/
	echo ("\t</div>\n");
	echo ("\t</div>\n");
}
echo ("</body>\n");
echo ("</html>\n");
?>
