﻿/**
 * Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

/* exported initSample */

if ( CKEDITOR.env.ie && CKEDITOR.env.version < 9 )
	CKEDITOR.tools.enableHtml5Elements( document );

// The trick to keep the editor in the sample quite small
// unless user specified own height.
CKEDITOR.config.height = 400;
CKEDITOR.config.width = 'auto';
CKEDITOR.config.baseFloatZIndex = 21;

var initTMSEditor = ( function() {
	var wysiwygareaAvailable = isWysiwygareaAvailable(),
		isBBCodeBuiltIn = !!CKEDITOR.plugins.get( 'bbcode' );

	return function() {
		var editorElement = CKEDITOR.document.getById( 'advancedtobeedited' );

		// :(((
		if ( isBBCodeBuiltIn ) {
			editorElement.setHtml(
				'Hello world!\n\n' +
				'I\'m an instance of [url=http://ckeditor.com]CKEditor[/url].'
			);
		}

		// Depending on the wysiwygare plugin availability initialize classic or inline editor.
		if ( wysiwygareaAvailable ) {
			CKEDITOR.replace( 'advancedtobeedited', { 
				on: { 
					'instanceReady': function (evt) { 
						evt.editor.execCommand('maximize'); 
					}
				},
				// Enabling extra plugins, available in the full-all preset: http://ckeditor.com/presets-all
				extraPlugins: 'tableresize,tmspdf,tmsitinerary,tmsdelete,tmsgooglemap',
				// An array of stylesheets to style the WYSIWYG area.
				// Note: it is recommended to keep your own styles in a separate file in order to make future updates painless.
				contentsCss: [ '/system/itinerary/style.css', '/system/itinerary/ckeditor.css' ],
				bodyClass: 'document-editor',
			});

		} else {
			editorElement.setAttribute( 'contenteditable', 'true' );
			CKEDITOR.inline( 'advancedtobeedited' );

			// TODO we can consider displaying some info box that
			// without wysiwygarea the classic editor may not work.
		}
	};

	function isWysiwygareaAvailable() {
		// If in development mode, then the wysiwygarea must be available.
		// Split REV into two strings so builder does not replace it :D.
		if ( CKEDITOR.revision == ( '%RE' + 'V%' ) ) {
			return true;
		}

		return !!CKEDITOR.plugins.get( 'wysiwygarea' );
	}
} )();

