/**
 * Plugin to get Google Map
 * @license Costa Rica Virtual 
 * Year 2019
 * Author: Juan Carlos Alvarez Alfaro
 * Map Types: roadmap, satellite, terrain, hybrid
 * Markers color: black, brown, green, purple, yellow, blue, gray, orange, red, white
 * Zoom level: 10: City, 15: Streets, 20: Buildings
 * 
 */
CKEDITOR.dialog.add( 'tmsgooglemapDialog', function( editor ) {

    return {
        title: 'Insert Google Map',
        minWidth: 400,
        minHeight: 75,
        contents: [
            {
                id: 'tab-basic',
                label: 'Basic Settings',
                elements: [
                    {
                        type: 'text',
                        id: 'addressStr',
                        label: 'Place Name, Location, Country'
                    },
					{
						type: 'hbox',
						widths: [ '33%', '33%', '33%' ],
						children: [
							{
								type: 'text',
								id: 'mapWidth',
								label: 'Map Width (px)',
								'default': '450',
							},
							{
								type: 'text',
								id: 'mapHeight',
								label: 'Map Height (px)',
								'default': '450',
							},
							{
								type: 'text',
								id: 'markerLabel',
								label: 'Marker Label: A-Z or 1-9',
								'default': 'H',
							},
						]
					}
				]
			},
			{
				id: 'tab-advanced',
                label: 'Advanced Settings',
                elements: [
					{
						type: 'hbox',
						widths: [ '33%', '33%', '33%' ],
						children: [
						   {
								type: 'select',
								id: 'zoomLevel',
								label: 'Zoom level',
								'default': '16',
								items: [ [ '10' ], [ '11' ], [ '12' ], [ '13' ], [ '14' ], [ '15' ], [ '16' ], [ '17' ], [ '18' ], [ '19' ], [ '20' ] ],	
							},
							{
								type: 'select',
								id: 'mapType',
								label: 'Map Type',
								'default': 'roadmap',
								items: [ [ 'Roadmap','roadmap' ], [ 'Satellite','satellite' ], [ 'Terrain','terrain' ], [ 'Hybrid','hybrid' ] ],
							},
							{
								type: 'select',
								id: 'markerColor',
								label: 'Marker Color',
								'default': 'blue',
								items: [ [ 'Black','black' ], [ 'Brown','brown' ], [ 'Green','green' ], [ 'Purple','purple' ], [ 'Yellow','yellow' ], [ 'Blue','blue' ], [ 'Gray','gray' ], [ 'Orange','orange' ], [ 'Red','red' ], [ 'White','white' ] ],	
							}
						]
					}
				]
           }
        ],
        onOk: function() {
            var dialog = this;
            var placeAddress = dialog.getValueOf('tab-basic', 'addressStr').trim();
            var mapWidth = dialog.getValueOf('tab-basic', 'mapWidth').trim();
            var mapHeight = dialog.getValueOf('tab-basic', 'mapHeight').trim();
			var mapType = dialog.getValueOf('tab-advanced', 'mapType').trim();
			var zoomLevel = dialog.getValueOf('tab-advanced', 'zoomLevel').trim();
			var markerColor = dialog.getValueOf('tab-advanced', 'markerColor').trim();
			var markerLabel = dialog.getValueOf('tab-basic', 'markerLabel').trim();

			var googleMapLink = 'https://maps.googleapis.com/maps/api/staticmap' +
					'?center=' + placeAddress + 
					'&zoom=' + zoomLevel +
					'&scale=1&size=' + mapWidth + 'x' + mapHeight +
					'&key=AIzaSyAefkm-SSCFAMHF3ngr6YlxwWvuJ-GDTHw' +
					'&maptype=' + mapType +
					'&format=png&visual_refresh=true' + 
					'&markers=color:' + markerColor + '|label:' + markerLabel + 
					'|' + placeAddress;
					
            var newImg = editor.document.createElement( 'img' );
            newImg.setAttribute('width', mapWidth);
            newImg.setAttribute('height', mapHeight);
			newImg.setAttribute('src', googleMapLink);

            editor.insertElement( newImg );
        }
    };
});