<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
if (!defined('TMS_ROOT')) {
	exit();
}
include_once TMS_ROOT."/class/db/access.php";
/**
 * Description of tmsFinance
 * Calculate all income, fees and charges for a specific itinerary
 * @author Juan Ca
 */
class tmsFinance {
    var $agentreferral;
    var $customer;
    var $itinerary;
    var $provider_refund;
    var $subtotal;
    var $racktotal;
    var $markup;
    var $proc_fee; // Processing Fee
    var $client_refund;
    var $fees;
    var $add_markup;
    var $discount;
    var $credit;
    var $total_price;
    var $agent_referral_comm;
    var $user_commission;
    var $vcomms;
    var $agent_commission;
    var $total_costs;
    var $total_income;
    var $net_margin;
    var $total_charged;
    var $reimbursement;
    var $factor;
	var $ecommerce;
        
    function tmsFinance($customerId) {
        global $db, $dbpanel;
        $customerId = intval($customerId);
        // sql to get customer info
        $this->customer =& $db->queryUniqueArray("SELECT * FROM customers WHERE `Customer Id`=".$customerId);
        // sql to get customer credit info
        $this->credit = 0;
        if($this->customer["Credit Id"] > 0) {
            $this->credit =& $db->queryUniqueValue("SELECT monto FROM $dbpanel.creditos "
                . "WHERE id_credito = ".$this->customer["Credit Id"]."");
        }
        // sql to get itinerary info
        $this->itinerary =& $db->queryUniqueArray("SELECT 
            SUM(IF(`Net Currency`='EUR',`Amount Billed`/`Net Rate`,`Amount Billed`/`Net Rate`)) Net, 
            SUM(IF(`Net Currency`='EUR',`Amount Confirmed`/`Net Rate`,`Amount Confirmed`/`Net Rate`)) Rack FROM itineraries 
            WHERE `Customer Id`=".$customerId." GROUP BY `Customer Id`");
        // sql to get vendor commission
        $this->vcomms =& $db->queryUniqueValue("SELECT Commission FROM vendors_commission WHERE `Customer Id` = '".$customerId."'");
        // sql to get agent referral
        $this->agentreferral =& $db->queryUniqueArray("SELECT `Agent` `agent`, `Commission Pc` `commpc` "
            . "FROM agent_referral "
            . "WHERE `Customer Id` = ".$customerId."");
        // sql to get charges
        $this->total_charged =& $db->queryUniqueValue("SELECT SUM(A.monto) FROM $dbpanel.pagos P, $dbpanel.abonos A
        WHERE P.CustomerId = '".$this->customer["Customer Number"]."' AND P.id_pago = A.pago");
        // sql to get amount added to magento
        $this->ecommerce =& $db->queryUniqueValue("SELECT SUM(mg_product_price) FROM ecommerce WHERE `Customer Id` = '".$customerId."'");
		// sql to get reimbursements
		$this->reimbursement =& $db->queryUniqueArray("SELECT SUM(d.admFee) `adm`, SUM(d.netoDevolucion) `net`
		FROM $dbpanel.pagos P, $dbpanel.devoluciones d 
		WHERE P.CustomerId = '".$this->customer["Customer Number"]."' AND P.id_pago = d.pago");
    }
    
    function getTotalCharged() {
        return $this->total_charged;
    }
    
    function getFactor() {
        $this->factor = $this->customer["factor"];
        return money_format('%.2n',$this->factor);
    }
    
    function getProviderRefund() {
        // Provider Refund
        $this->provider_refund = $this->customer["Provider refund"];
        return $this->provider_refund;
    }
    
    function getSubtotal() {
        // Net Total
        $this->subtotal = money_format('%.2n',$this->itinerary["Net"]);
        return $this->subtotal;
    }

    function getRacktotal() {
        // Rack Total
        $this->racktotal = money_format('%.2n',$this->itinerary["Rack"]);
        return $this->racktotal;
    }

    function getMarkup() {
        $this->getRacktotal();
        $this->getSubtotal();
        // Markup
        $this->markup = $this->racktotal-$this->subtotal;
        return $this->markup;
    }

    function getProcFee() {
        // Procesing Fee
        $this->proc_fee = $this->customer["procfee"];
        return $this->proc_fee;
    }

    function getClientRefund() {
        // Client Refund
        $this->client_refund = $this->customer["Client credit"];
        return $this->client_refund;
    }
        
    function getFees() {
        // Sum fees
        $this->fees = $this->customer["CC Fee"]+$this->customer["Mailing Cost"]+$this->customer["Wire Fee"]+$this->customer["Other Fees"]+$this->customer["Markup TA"];
        return $this->fees;
    }

    function getAddMarkup() {
        // Additional Markup
        $this->add_markup= $this->customer["Add Markup"];
        return $this->add_markup;
    }

    function getDiscount() {
        // Discount
        $this->discount = $this->customer["Discount"];
        return $this->discount;
    }

    function getCredit() {
        // Get credit for this customer
        return $this->credit;
    }

    function getTotalPrice() {
        $this->getRacktotal();
        $this->getAddMarkup();
        $this->getProcFee();
        $this->getDiscount();
        // Total Price
        $this->total_price = $this->racktotal+$this->add_markup+$this->proc_fee-$this->discount;
        return $this->total_price;
    }

    function getAgentReferralComm() {
        // Agent Referral Commission
        $this->agent_referral_comm = 0;
        if($this->agentreferral["agent"]!=""){
            $this->getTotalPrice();
            $this->getProviderRefund();
            $this->getSubtotal();
            $this->getFees();
            $this->getClientRefund();
            $this->agent_referral_comm = (($this->total_price - $this->proc_fee + $this->provider_refund 
                - $this->subtotal - $this->fees - $this->client_refund) * $this->agentreferral["commpc"])/100;
            $sql="UPDATE agent_referral SET `Commission` = ".$this->agent_referral_comm
                . " WHERE `Customer Id` = ".$this->customer["Customer Id"]."";
            updateTMS($sql);
            $this->agent_referral_comm = money_format('%.2n',$this->agent_referral_comm);
        }
        return $this->agent_referral_comm;
    }

    function getUserCommission() {
        // Agent Commission
        $this->user_commission = $this->customer["commissionpc"];
        if($this->customer["commissionpc"] == 1) {
            $this->user_commission = $db->queryUniqueValue("SELECT commission FROM users_users WHERE CONCAT(firstname, ' ', lastname) = '".$this->customer['Last updated by']."'");
            $sql="UPDATE customers SET commissionpc = ".$this->user_commission .
            " WHERE `Customer Id` = ".$this->customer["Customer Id"]."";
            updateTMS($sql);
        }
        return $this->user_commission;
    }

    function getVendorCommission() {
        // Vendors Commission
        if ($this->vcomms == '' || is_null($this->vcomms)) { 
            $this->vcomms = 0; 
        }
        return $this->vcomms;
    }

    function getAgentCommission() {
        $this->getTotalPrice();
        $this->getProviderRefund();
        $this->getSubtotal();
        $this->getFees();
        $this->getClientRefund();
        $this->getVendorCommission();
        $this->getUserCommission();
        // commission
        $commission = (($this->total_price - $this->proc_fee + $this->provider_refund - $this->subtotal - $this->fees - $this->client_refund + $this->vcomms) * $this->user_commission) / 100;
        $commission = money_format('%.2n',$commission);
        if($commission != $this->customer["Agent Commission"]) {
            $this->customer["Agent Commission"] = $commission;
        }
        $this->agent_commission = $this->customer["Agent Commission"];
        return $this->agent_commission;
    }

    function getTotalCost() {
        $this->getAgentCommission();
        $this->getAgentReferralComm();
        // total costs
        $this->total_costs = $this->subtotal - $this->provider_refund + $this->fees + $this->agent_commission + $this->agent_referral_comm;
        return $this->total_costs;
    }

    function getTotalIncome() {
        $this->getTotalPrice();
        $this->getClientRefund();
        $this->getVendorCommission();
        // total income
        $this->total_income = $this->total_price - $this->client_refund + $this->vcomms;
        return money_format('%.2n',$this->total_income);
    }

    function getBalance() {
		return money_format('%.2n', $this->getTotalIncome() - $this->getTotalCharged() - $this->getCredit() + $this->reimbursement["net"]);
    }

    function getNetMargin() {
        $this->getTotalIncome();
        $this->getTotalCost();
        // Net Margin
        $this->net_margin = $this->total_income - $this->total_costs;
        return $this->net_margin;
    }

    function getEcommerce() {
        // Get ecommerce amount for this customer
        return $this->ecommerce;
    }
}

/**
 * Update TMS database
 *
 * @param    string  $query         Query to run
 *
 */
function updateTMS($query='') {
    if($query != '') {
        global $db;
        $db->execute($query);
    }
}