<?php
require_once 'API.class.php';
class MyAPI extends API
{
    protected $xml;
	protected $tables = array(
		'seo' => 'seo_status',
		'leads' => 'leads'
	);

    public function __construct($request, $origin) {
        parent::__construct($request);
    }

	public function parseResult($resultXML) {
		try {
			$data = new SimpleXMLElement($resultXML);
		} catch (Exception $ex) {
			return new Result(Result::ERROR_LEVEL_FATAL, 'A cURL error occurred. Bad response<br>'.$ex->getMessage());
		}
		return $data;
	}

	/**
	 * Connect to seo table. Generate XML with result data 
	 * depends on verb
	 * 
	 * @return string The returned XML as a string.
	 * @throws \InvalidArgumentException
	 */
     protected function seo() {
		require_once '../seo/class.php';
		$seoObj = new SEO();
		$params = self::parseResult($this->file);
		switch($this->verb) {
        case 'read':
			$criteria = "`id` = " . $params->id;
			$data =& $seoObj->getObjects($criteria, '', '');
			if ($data) { 
				$itemArr = json_decode(json_encode($data), true);
				//print_r($itemArr[(int)$params->id]['vars']);
				$this->xml = $this->generateXML($itemArr[(int)$params->id]['vars']);
				return $this->xml;
			} else {
				$this->_response('Module: ' . $this->module . ', Action: ' . $this->verb . '. Failed. No data found', 405);
			}
            break;
        default:
            $this->_response('Invalid Method', 405);
            break;
        }
		/*
		$data = array(
			'original_title' => char_decode($thisitem->getVar('original_title')),
			'original_description' => char_decode($thisitem->getVar('original_description')),
			'original_keywords' => char_decode($thisitem->getVar('original_keywords')),
			'new_title' => char_decode($thisitem->getVar('new_title')),
			'new_description' => char_decode($thisitem->getVar('new_description')),
			'new_keywords' => char_decode($thisitem->getVar('new_keywords'))
		);
		*/
	 }

	/**
	 * Connect to LEADS table. Generate XML with result data 
	 * depends on verb
	 * 
	 * @return string The returned XML as a string.
	 * @throws \InvalidArgumentException
	 */
     protected function leads() {
		require_once '../leads/leads.class.php';
		$leadObj = new Leads();
		switch($this->verb) {
        case 'read':
			$params = self::parseResult($this->file);
			$criteria = "`id` = " . $params->id;
			$data =& $leadObj->getObjects($criteria, '', '');
			if ($data) { 
				$itemArr = json_decode(json_encode($data), true);
				//print_r($itemArr[(int)$params->id]['vars']);
				$this->xml = $this->generateXML($itemArr[(int)$params->id]['vars']);
				return $this->xml;
			} else {
				$this->_response('Module: ' . $this->module . ', Action: ' . $this->verb . '. Failed. No data found', 405);
			}
            break;
		case 'write':
			$params = self::parseResult($this->file);
			$data = json_decode(json_encode($params), true);
			// remove unnecessary elements
			unset($data['module']);
			unset($data['method']);
			unset($data['@attributes']);
			//print_r($this->file); 
			$data  =& $leadObj->putObjects($data);
			if ($data) { 
				$itemArr['newId'] = $data;
				$this->xml = $this->generateXML($itemArr);
				return $this->xml;
			} else {
				$this->_response('Module: ' . $this->module . ', Action: ' . $this->verb . '. Failed. No data found', 405);
			}			
			break;
        default:
            $this->_response('Invalid Method', 405);
            break;
        }
	}

	/**
	 * Connect to CUSTOMERS table. Generate XML with result data 
	 * depends on verb
	 * 
	 * @return string The returned XML as a string.
	 * @throws \InvalidArgumentException 
	 */
     protected function customers() {
		require_once '../class/customers/customers.class.php';
		$customerObj = new Customers();
		$params = self::parseResult($this->file);
		switch($this->verb) {
        case 'read':
			$criteria = "`id` = " . $params->id;
			$data =& $customerObj->getObjects($criteria, '', '');
			if ($data) { 
				$itemArr = json_decode(json_encode($data), true);
				$this->xml = $this->generateXML($itemArr[(int)$params->id]['vars']);
				return $this->xml;
			} else {
				$this->_response('Module: ' . $this->module . ', Action: ' . $this->verb . '. Failed. No data found', 405);
			}
            break;
		case 'write':
			$data = json_decode(json_encode($params), true);
			// remove unnecessary elements
			unset($data['module']);
			unset($data['method']);
			unset($data['@attributes']);
			$data  =& $customerObj->putObjects($data);
			//tms_debug($data, "Data:");
			if ($data) { 
				$itemArr['newId'] = $data;
				$this->xml = $this->generateXML($itemArr);
				return $this->xml;
			} else {
				$itemArr['module'] = $this->module;
				$itemArr['action'] = $this->verb;
				$itemArr['error'] = 'Record not Inserted';
				$this->xml = $this->generateXML($itemArr);
				return $this->xml;
				//return $this->_response('Module: ' . $this->module . ', Action: ' . $this->verb . '. Failed. Record not Inserted', 405);
			}
			break;
        default:
            $this->_response('Invalid Method', 405);
            break;
        }
	}

    /**
     * Example of an Endpoint
     */
     protected function example() {
        if ($this->method == 'GET') {
			$result  = "Method: " . $this->method;
			$result .= ",<br>Endpoint: " . $this->endpoint;
			$result .= ",<br>Verb: " . $this->verb;
			foreach ($this->args as $k => $v) {
				$result .= ",<br>Args[$k]: $v";
			}
			return $result;
        } elseif ($this->method == 'POST') {
			$result = self::parseResult($this->file, 'params');
			$this->xml = $this->generateXML($result);
			return $this->xml;
		} else {
			return "Method used: $this->method";
		}
	}
 }